/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi3d;

import icy.canvas.IcyCanvas;
import icy.common.CollapsibleEvent;
import icy.math.Line3DIterator;
import icy.painter.Anchor3D;
import icy.resource.ResourceUtil;
import icy.roi.ROI;
import icy.roi.ROIEvent;
import icy.sequence.Sequence;
import icy.type.geom.Line3D;
import icy.type.geom.Polyline3D;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import icy.vtk.IcyVtkPanel;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.kernel.canvas.VtkCanvas;
import plugins.kernel.roi.roi3d.ROI3DShape;
import vtk.vtkDataObject;
import vtk.vtkTubeFilter;

public class ROI3DPolyLine
extends ROI3DShape {
    public ROI3DPolyLine(Point3D pt) {
        super(new Polyline3D());
        Anchor3D anchor = this.createAnchor(pt);
        this.addPoint(anchor);
        anchor.setSelected(true);
        this.updateShape();
        this.setIcon(ResourceUtil.ICON_ROI_POLYLINE);
    }

    public ROI3DPolyLine(Point5D pt) {
        this(pt.toPoint3D());
    }

    public ROI3DPolyLine(Polyline3D polyline) {
        this(new Point3D.Double());
        this.setPolyline3D(polyline);
    }

    public ROI3DPolyLine(List<Point3D> points) {
        this(new Point3D.Double());
        this.setPoints(points);
    }

    public ROI3DPolyLine() {
        this(new Point3D.Double());
    }

    @Override
    public String getDefaultName() {
        return "PolyLine3D";
    }

    @Override
    protected ROI3DPolyLinePainter createPainter() {
        return new ROI3DPolyLinePainter();
    }

    public Polyline3D getPolyline3D() {
        return (Polyline3D)this.shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoints(List<Point3D> pts) {
        this.beginUpdate();
        try {
            this.removeAllPoint();
            for (Point3D pt : pts) {
                this.addNewPoint(pt, false);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setPolyline3D(Polyline3D value) {
        this.beginUpdate();
        try {
            this.removeAllPoint();
            for (int i = 0; i < value.npoints; ++i) {
                this.addNewPoint(new Point3D.Double(value.xpoints[i], value.ypoints[i], value.zpoints[i]), false);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    protected double getTotalDistance(List<Point3D> points, double factorX, double factorY, double factorZ) {
        return Point3D.getTotalDistance(points, factorX, factorY, factorZ, false);
    }

    @Override
    public boolean[] getBooleanMask2D(int x, int y, int width, int height, int z, boolean inclusive) {
        if (width <= 0 || height <= 0) {
            return new boolean[0];
        }
        List<Point3D> points = this.getPointsInternal();
        boolean[] result = new boolean[width * height];
        Rectangle bounds2d = new Rectangle(x, y, width, height);
        for (int i = 1; i < points.size(); ++i) {
            ROI3DPolyLine.drawLine3DInBooleanMask2D(bounds2d, result, z, points.get(i - 1), points.get(i));
        }
        return result;
    }

    public static void drawLine3DInBooleanMask2D(Rectangle bounds2d, boolean[] result, int z, Point3D p1, Point3D p2) {
        Line2D.Double l = new Line2D.Double(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        if (l.intersects(bounds2d) && (p1.getZ() <= (double)z && p2.getZ() >= (double)z || p2.getZ() <= (double)z && p1.getZ() >= (double)z)) {
            int bx = bounds2d.x;
            int by = bounds2d.y;
            int pitch = bounds2d.width;
            Line3DIterator it = new Line3DIterator(new Line3D(p1, p2), 1.0);
            while (it.hasNext()) {
                int y;
                int x;
                Point3D pt = it.next();
                if (Math.floor(pt.getZ()) != (double)z || !bounds2d.contains(x = (int)Math.floor(pt.getX()), y = (int)Math.floor(pt.getY()))) continue;
                result[x - bx + (y - by) * pitch] = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChanged(CollapsibleEvent object) {
        ROIEvent event = (ROIEvent)object;
        switch (event.getType()) {
            case ROI_CHANGED: {
                this.updateShape();
                break;
            }
            case FOCUS_CHANGED: {
                ((ROI3DPolyLinePainter)this.getOverlay()).updateVtkDisplayProperties();
                break;
            }
            case SELECTION_CHANGED: {
                boolean s = this.isSelected();
                List list = this.controlPoints;
                synchronized (list) {
                    for (Anchor3D pt : this.controlPoints) {
                        pt.setVisible(s);
                        if (s) continue;
                        pt.setSelected(false);
                    }
                }
                ((ROI3DPolyLinePainter)this.getOverlay()).updateVtkDisplayProperties();
                break;
            }
            case PROPERTY_CHANGED: {
                String property = event.getPropertyName();
                if (!StringUtil.equals(property, "stroke") && !StringUtil.equals(property, "color") && !StringUtil.equals(property, "opacity")) break;
                ((ROI3DPolyLinePainter)this.getOverlay()).updateVtkDisplayProperties();
                break;
            }
        }
        super.onChanged(object);
    }

    @Override
    public double computeNumberOfPoints() {
        return 0.0;
    }

    @Override
    public boolean contains(ROI roi) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateShape() {
        Polyline3D polyline3d;
        int len = this.controlPoints.size();
        double[] ptsX = new double[len];
        double[] ptsY = new double[len];
        double[] ptsZ = new double[len];
        for (int i = 0; i < len; ++i) {
            Anchor3D pt = (Anchor3D)this.controlPoints.get(i);
            ptsX[i] = pt.getX();
            ptsY[i] = pt.getY();
            ptsZ[i] = pt.getZ();
        }
        Polyline3D polyline3D = polyline3d = this.getPolyline3D();
        synchronized (polyline3D) {
            polyline3d.npoints = len;
            polyline3d.xpoints = ptsX;
            polyline3d.ypoints = ptsY;
            polyline3d.zpoints = ptsZ;
            polyline3d.calculateLines();
        }
        super.updateShape();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                boolean bl = false;
                return bl;
            }
            this.removeAllPoint();
            ArrayList<Node> nodesPoint = XMLUtil.getChildren(XMLUtil.getElement(node, "points"), "point");
            if (nodesPoint != null) {
                for (Node n : nodesPoint) {
                    Anchor3D pt = this.createAnchor(new Point3D.Double());
                    pt.loadPositionFromXML(n);
                    this.addPoint(pt);
                }
            }
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        Element dependances = XMLUtil.setElement(node, "points");
        for (Anchor3D pt : this.controlPoints) {
            pt.savePositionToXML(XMLUtil.addElement(dependances, "point"));
        }
        return true;
    }

    public class ROI3DPolyLinePainter
    extends ROI3DShape.ROI3DShapePainter {
        protected vtkTubeFilter tubeFilter;

        public ROI3DPolyLinePainter() {
            super(ROI3DPolyLine.this);
            this.tubeFilter = null;
        }

        @Override
        protected void finalize() throws Throwable {
            super.finalize();
            if (this.tubeFilter != null) {
                this.tubeFilter.Delete();
            }
        }

        @Override
        protected void initVtkObjects() {
            super.initVtkObjects();
            this.tubeFilter = new vtkTubeFilter();
            this.tubeFilter.SetInputData((vtkDataObject)this.polyData);
            this.tubeFilter.SetRadius(1.0);
            this.tubeFilter.CappingOn();
            this.tubeFilter.SetNumberOfSides(8);
            this.polyMapper.SetInputConnection(this.tubeFilter.GetOutputPort());
        }

        @Override
        protected void rebuildVtkObjects() {
            super.rebuildVtkObjects();
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel = canvas.getVtkPanel();
            if (vtkPanel == null) {
                return;
            }
            if (this.tubeFilter == null) {
                return;
            }
            vtkPanel.lock();
            try {
                this.tubeFilter.Update();
            }
            finally {
                vtkPanel.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateVtkTubeRadius() {
            if (this.actor == null) {
                return;
            }
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel = canvas.getVtkPanel();
            if (vtkPanel == null) {
                return;
            }
            if (this.tubeFilter == null) {
                return;
            }
            double radius = canvas.canvasToImageLogDeltaX((int)this.getStroke()) * this.scaling[0];
            if (this.tubeFilter.GetRadius() != radius) {
                vtkPanel.lock();
                try {
                    this.tubeFilter.SetRadius(radius);
                    this.tubeFilter.Update();
                }
                finally {
                    vtkPanel.unlock();
                }
                this.painterChanged();
            }
        }

        @Override
        public void drawROI(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            super.drawROI(g, sequence, canvas);
            if (canvas instanceof VtkCanvas) {
                this.updateVtkTubeRadius();
            }
        }

        @Override
        protected void drawShape(Graphics2D g, Sequence sequence, IcyCanvas canvas, boolean simplified) {
            this.drawShape(g, sequence, canvas, simplified, false);
        }
    }
}

