/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi3d;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.painter.Anchor3D;
import icy.painter.Overlay;
import icy.painter.OverlayEvent;
import icy.painter.OverlayListener;
import icy.painter.ZBoxAnchor3D;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROIEvent;
import icy.roi.ROIListener;
import icy.sequence.Sequence;
import icy.type.geom.ZShape3D;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.util.ColorUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import icy.vtk.IcyVtkPanel;
import icy.vtk.VtkUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import plugins.kernel.canvas.VtkCanvas;
import plugins.kernel.roi.roi2d.ROI2DShape;
import plugins.kernel.roi.roi3d.ROI3DShape;
import vtk.vtkCellArray;
import vtk.vtkPoints;

public abstract class ROI3DZShape
extends ROI3DShape {
    public static final String ID_BASE_ROI = "shape2DROI";
    public static final String ID_POS_Z = "z";
    public static final String ID_SIZE_Z = "sizeZ";
    public static final String ID_CLOSEZ = "close_z";
    public static final String ID_FARZ = "far_z";
    protected final ROI2DShape shape2DROI;
    protected final ZBoxAnchor3D closeZ;
    protected final ZBoxAnchor3D farZ;

    public ROI3DZShape(ZShape3D shape) {
        super(shape);
        Rectangle3D bounds = shape.getBounds();
        this.closeZ = new ZBoxAnchor3D(new Point3D.Double(bounds.getCenterX(), bounds.getCenterY(), bounds.getMinZ()), ColorUtil.mix(ColorUtil.mix(this.getColor(), Color.lightGray), Color.lightGray), this.getFocusedColor());
        this.farZ = new ZBoxAnchor3D(new Point3D.Double(bounds.getCenterX(), bounds.getCenterY(), bounds.getMaxZ()), ColorUtil.mix(ColorUtil.mix(this.getColor(), Color.lightGray), Color.lightGray), this.getFocusedColor());
        this.addPoint(this.closeZ);
        this.addPoint(this.farZ);
        this.shape2DROI = this.createROI2DShape();
        this.shape2DROI.setZ(-1);
        this.shape2DROI.addListener(new ROIListener(){

            @Override
            public void roiChanged(ROIEvent event) {
                ROI3DZShape.this.shape2DROIChanged(event);
            }
        });
        this.getShape2DROIOverlay().addOverlayListener(new OverlayListener(){

            @Override
            public void overlayChanged(OverlayEvent event) {
                ROI3DZShape.this.shape2DROIOverlayChanged(event);
            }
        });
    }

    @Override
    public String getDefaultName() {
        return "ROI3DZShape";
    }

    protected abstract ROI2DShape createROI2DShape();

    @Override
    protected ROI3DShape.ROI3DShapePainter createPainter() {
        return new ROI3DZShapePainter();
    }

    protected ZShape3D getZShape() {
        return (ZShape3D)this.shape;
    }

    public ROI2DShape getShape2DROI() {
        return this.shape2DROI;
    }

    protected ROI2DShape.ROI2DShapePainter getShape2DROIOverlay() {
        return (ROI2DShape.ROI2DShapePainter)this.getShape2DROI().getOverlay();
    }

    @Override
    public void setCreating(boolean value) {
        this.beginUpdate();
        try {
            super.setCreating(value);
            this.shape2DROI.setCreating(value);
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public void setReadOnly(boolean value) {
        this.beginUpdate();
        try {
            super.setReadOnly(value);
            this.shape2DROI.setReadOnly(value);
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public void setFocused(boolean value) {
        this.beginUpdate();
        try {
            super.setFocused(value);
            this.shape2DROI.setFocused(value);
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public void setSelected(boolean value) {
        this.beginUpdate();
        try {
            super.setSelected(value);
            this.shape2DROI.setSelected(value);
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public void setName(String value) {
        this.beginUpdate();
        try {
            super.setName(value);
            this.shape2DROI.setName(value);
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public void setT(int value) {
        this.beginUpdate();
        try {
            super.setT(value);
            this.shape2DROI.setT(value);
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public void setC(int value) {
        this.beginUpdate();
        try {
            super.setC(value);
            this.shape2DROI.setC(value);
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getBounds3D().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Point3D> getPoints() {
        ArrayList<Point3D> result = new ArrayList<Point3D>();
        List list = this.controlPoints;
        synchronized (list) {
            for (Anchor3D pt : this.controlPoints) {
                if (pt == this.farZ || pt == this.closeZ) continue;
                result.add(pt.getPosition());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Point3D> getPointsInternal() {
        ArrayList<Point3D> result = new ArrayList<Point3D>();
        List list = this.controlPoints;
        synchronized (list) {
            for (Anchor3D pt : this.controlPoints) {
                if (pt == this.farZ || pt == this.closeZ) continue;
                result.add(pt.getPositionInternal());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Point2D> getPoints2D() {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        List list = this.controlPoints;
        synchronized (list) {
            for (Anchor3D pt : this.controlPoints) {
                if (pt == this.farZ || pt == this.closeZ) continue;
                result.add(pt.getPosition().toPoint2D());
            }
        }
        return result;
    }

    @Override
    public boolean hasSelectedPoint() {
        if (this.shape2DROI == null) {
            return false;
        }
        return this.shape2DROI.hasSelectedPoint();
    }

    @Override
    public void unselectAllPoints() {
        if (this.shape2DROI != null) {
            this.shape2DROI.unselectAllPoints();
        }
    }

    @Override
    protected boolean removePoint(IcyCanvas canvas, Anchor3D pt) {
        if (pt == this.farZ || pt == this.closeZ) {
            return false;
        }
        return super.removePoint(canvas, pt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeAllPoint() {
        ArrayList<Anchor3D> toRemove = new ArrayList<Anchor3D>();
        List list = this.controlPoints;
        synchronized (list) {
            for (Anchor3D pt : this.controlPoints) {
                if (pt == this.farZ || pt == this.closeZ) continue;
                toRemove.add(pt);
            }
            Object object = ((ROI3DShape.ROI3DShapePainter)this.getOverlay()).actorsToRemove;
            synchronized (object) {
                ((ROI3DShape.ROI3DShapePainter)this.getOverlay()).actorsToRemove.addAll(toRemove);
            }
            object = ((ROI3DShape.ROI3DShapePainter)this.getOverlay()).actorsToAdd;
            synchronized (object) {
                ((ROI3DShape.ROI3DShapePainter)this.getOverlay()).actorsToAdd.removeAll(toRemove);
            }
            for (Anchor3D pt : toRemove) {
                pt.removeOverlayListener(this.anchor3DOverlayListener);
                pt.removePositionListener(this.anchor3DPositionListener);
            }
            this.controlPoints.removeAll(toRemove);
        }
    }

    protected void shape2DROIChanged(ROIEvent event) {
        ROI source = event.getSource();
        switch (event.getType()) {
            case ROI_CHANGED: {
                this.updateFromShape2DROI();
                this.roiChanged(StringUtil.equals(event.getPropertyName(), "all"));
                break;
            }
            case FOCUS_CHANGED: {
                this.setFocused(source.isFocused());
                break;
            }
            case SELECTION_CHANGED: {
                this.setSelected(source.isSelected());
                break;
            }
            case PROPERTY_CHANGED: {
                String propertyName = event.getPropertyName();
                if (propertyName == null || propertyName.equals("readOnly")) {
                    this.setReadOnly(source.isReadOnly());
                }
                if (propertyName != null && !propertyName.equals("creating")) break;
                this.setCreating(source.isCreating());
            }
        }
    }

    protected void shape2DROIOverlayChanged(OverlayEvent event) {
        switch (event.getType()) {
            case PAINTER_CHANGED: {
                this.getOverlay().painterChanged();
                break;
            }
            case PROPERTY_CHANGED: {
                this.getOverlay().propertyChanged(event.getPropertyName());
            }
        }
    }

    @Override
    public boolean isActiveFor(IcyCanvas canvas) {
        int cnvZ = canvas.getPositionZ();
        return (cnvZ == -1 || this.getZShape().containsZ(cnvZ)) && this.isActiveFor(canvas.getPositionT(), canvas.getPositionC());
    }

    @Override
    public double computeNumberOfContourPoints() throws InterruptedException {
        return this.shape2DROI.getNumberOfPoints() * 2.0 + this.shape2DROI.getNumberOfContourPoints() * this.getZShape().getSizeZ();
    }

    @Override
    public double computeNumberOfPoints() throws InterruptedException {
        return this.shape2DROI.getNumberOfPoints() * this.getZShape().getSizeZ();
    }

    @Override
    public double computeSurfaceArea(Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        double psx = sequence.getPixelSizeX();
        double psy = sequence.getPixelSizeY();
        double psz = sequence.getPixelSizeZ();
        return this.shape2DROI.getNumberOfPoints() * 2.0 * psx * psy + this.shape2DROI.getNumberOfContourPoints() * this.getZShape().getSizeZ() * psz;
    }

    @Override
    public boolean canTranslate() {
        return this.shape2DROI.canTranslate();
    }

    @Override
    public boolean canSetBounds() {
        return this.shape2DROI.canSetBounds();
    }

    @Override
    public void setBounds3D(Rectangle3D bounds) {
        if (!this.canSetBounds()) {
            return;
        }
        this.beginUpdate();
        try {
            this.shape2DROI.setBounds2D(bounds.toRectangle2D());
            this.closeZ.setZ(bounds.getMinZ());
            this.farZ.setZ(bounds.getMaxZ());
        }
        finally {
            this.endUpdate();
        }
    }

    public void translateZ(double deltaZ) {
        this.beginUpdate();
        try {
            this.closeZ.translate(0.0, 0.0, deltaZ);
            this.farZ.translate(0.0, 0.0, deltaZ);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translate(double dx, double dy, double dz) {
        this.beginUpdate();
        try {
            this.shape2DROI.translate(dx, dy);
            this.translateZ(dz);
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean[] getBooleanMask2D(int x, int y, int width, int height, int z, boolean inclusive) {
        ZShape3D zShape = (ZShape3D)this.getZShape().clone();
        if (inclusive && zShape.containsZ(z, 1.0) || zShape.containsZ(z)) {
            return this.shape2DROI.getBooleanMask(x, y, width, height, inclusive);
        }
        return new boolean[width * height];
    }

    @Override
    public BooleanMask2D getBooleanMask2D(int z, boolean inclusive) throws InterruptedException {
        ZShape3D zShape = (ZShape3D)this.getZShape().clone();
        if (inclusive && zShape.containsZ(z, 1.0) || zShape.containsZ(z)) {
            return this.shape2DROI.getBooleanMask(inclusive);
        }
        return new BooleanMask2D(new Rectangle(), new boolean[0]);
    }

    protected abstract void updateShape2DROI();

    protected abstract void updateFromShape2DROI();

    protected void updateShapeInternal() {
        this.getZShape().setZ(this.closeZ.getZ());
        this.getZShape().setSizeZ(this.farZ.getZ() - this.closeZ.getZ());
        this.boundsInvalid = true;
    }

    @Override
    protected void updateShape() {
        this.beginUpdate();
        try {
            this.updateShapeInternal();
            this.updateShape2DROI();
            super.updateShape();
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                boolean bl = false;
                return bl;
            }
            this.closeZ.loadPositionFromXML(XMLUtil.getElement(node, ID_CLOSEZ));
            this.farZ.loadPositionFromXML(XMLUtil.getElement(node, ID_FARZ));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        this.closeZ.savePositionToXML(XMLUtil.setElement(node, ID_CLOSEZ));
        this.farZ.savePositionToXML(XMLUtil.setElement(node, ID_FARZ));
        return true;
    }

    public class ROI3DZShapePainter
    extends ROI3DShape.ROI3DShapePainter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void rebuildVtkObjects() {
            int ind;
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel = canvas.getVtkPanel();
            if (vtkPanel == null) {
                return;
            }
            Sequence seq = canvas.getSequence();
            if (seq == null) {
                return;
            }
            double xs = this.scaling[0];
            double ys = this.scaling[1];
            double zs = this.scaling[2];
            ArrayList<double[]> point3DList = new ArrayList<double[]>();
            ArrayList<int[]> polyList = new ArrayList<int[]>();
            double[] coords = new double[6];
            ZShape3D zShape = (ZShape3D)ROI3DZShape.this.getZShape().clone();
            Rectangle3D bounds = ROI3DZShape.this.getBounds3D();
            double z0 = zShape.getMinZ() * zs;
            double z1 = zShape.getMaxZ() * zs;
            double xm = 0.0;
            double ym = 0.0;
            double x0 = 0.0;
            double y0 = 0.0;
            double x1 = 0.0;
            double y1 = 0.0;
            PathIterator path = zShape.get2DPathIterator(null, 0.5);
            while (!path.isDone()) {
                switch (path.currentSegment(coords)) {
                    case 0: {
                        x0 = xm = coords[0] * xs;
                        y0 = ym = coords[1] * ys;
                        break;
                    }
                    case 1: {
                        x1 = coords[0] * xs;
                        y1 = coords[1] * ys;
                        ind = point3DList.size();
                        point3DList.add(new double[]{x0, y0, z0});
                        point3DList.add(new double[]{x1, y1, z0});
                        point3DList.add(new double[]{x0, y0, z1});
                        point3DList.add(new double[]{x1, y1, z1});
                        polyList.add(new int[]{1 + ind, 2 + ind, 0 + ind});
                        polyList.add(new int[]{3 + ind, 2 + ind, 1 + ind});
                        x0 = x1;
                        y0 = y1;
                        break;
                    }
                    case 4: {
                        x1 = xm;
                        y1 = ym;
                        ind = point3DList.size();
                        point3DList.add(new double[]{x0, y0, z0});
                        point3DList.add(new double[]{x1, y1, z0});
                        point3DList.add(new double[]{x0, y0, z1});
                        point3DList.add(new double[]{x1, y1, z1});
                        polyList.add(new int[]{1 + ind, 2 + ind, 0 + ind});
                        polyList.add(new int[]{3 + ind, 2 + ind, 1 + ind});
                        x0 = x1;
                        y0 = y1;
                    }
                }
                path.next();
            }
            double[][] vertices = new double[point3DList.size()][3];
            int[][] indexes = new int[polyList.size()][3];
            ind = 0;
            for (double[] pt3D : point3DList) {
                vertices[ind++] = pt3D;
            }
            ind = 0;
            for (int[] poly : polyList) {
                indexes[ind++] = poly;
            }
            vtkPoints previousPoints = this.vPoints;
            vtkCellArray previousCells = this.vCells;
            vtkPoints newPoints = VtkUtil.getPoints(vertices);
            vtkCellArray newCells = VtkUtil.getCells(polyList.size(), VtkUtil.prepareCells(indexes));
            vtkPanel.lock();
            try {
                this.vPoints = newPoints;
                this.vCells = newCells;
                VtkUtil.setOutlineBounds(this.outline, bounds.getMinX() * xs, bounds.getMaxX() * xs, bounds.getMinY() * ys, bounds.getMaxY() * ys, z0, z1, canvas);
                this.outlineMapper.Update();
                this.polyData.SetPoints(this.vPoints);
                this.polyData.SetPolys(this.vCells);
                this.polyMapper.Update();
                if (previousPoints != null) {
                    previousPoints.Delete();
                }
                if (previousCells != null) {
                    previousCells.Delete();
                }
            }
            finally {
                vtkPanel.unlock();
            }
            this.updateVtkDisplayProperties();
        }

        @Override
        public void run() {
            this.rebuildVtkObjects();
        }

        @Override
        public void setReadOnly(boolean value) {
            super.setReadOnly(this.readOnly);
            ROI3DZShape.this.getShape2DROIOverlay().setReadOnly(value);
        }

        @Override
        public void setColor(Color value) {
            super.setColor(value);
            ROI3DZShape.this.closeZ.setColor(ColorUtil.mix(ColorUtil.mix(value, Color.lightGray), Color.lightGray));
            ROI3DZShape.this.farZ.setColor(ColorUtil.mix(ColorUtil.mix(value, Color.lightGray), Color.lightGray));
            ROI3DZShape.this.getShape2DROIOverlay().setColor(value);
        }

        @Override
        public void setOpacity(float value) {
            super.setOpacity(value);
            ROI3DZShape.this.getShape2DROIOverlay().setOpacity(value);
        }

        @Override
        public void setStroke(double value) {
            super.setStroke(value);
            ROI3DZShape.this.getShape2DROIOverlay().setStroke(value);
        }

        @Override
        public void setShowName(boolean value) {
            super.setShowName(value);
            ROI3DZShape.this.getShape2DROIOverlay().setShowName(value);
        }

        @Override
        public void setPriority(Overlay.OverlayPriority value) {
            super.setPriority(this.priority);
            ROI3DZShape.this.getShape2DROIOverlay().setPriority(value);
        }

        @Override
        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (ROI3DZShape.this.isActiveFor(canvas)) {
                super.paint(g, sequence, canvas);
            }
        }

        @Override
        public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (ROI3DZShape.this.isActiveFor(canvas)) {
                    ROI3DZShape.this.getShape2DROIOverlay().keyPressed(e, imagePoint, canvas);
                }
            } else {
                super.keyPressed(e, imagePoint, canvas);
            }
        }

        @Override
        public void keyReleased(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (ROI3DZShape.this.isActiveFor(canvas)) {
                    ROI3DZShape.this.getShape2DROIOverlay().keyReleased(e, imagePoint, canvas);
                }
            } else {
                super.keyReleased(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (ROI3DZShape.this.isActiveFor(canvas)) {
                    ROI3DZShape.this.getShape2DROIOverlay().mouseEntered(e, imagePoint, canvas);
                }
            } else {
                super.mouseEntered(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseExited(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (ROI3DZShape.this.isActiveFor(canvas)) {
                    ROI3DZShape.this.getShape2DROIOverlay().mouseExited(e, imagePoint, canvas);
                }
            } else {
                super.mouseExited(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (ROI3DZShape.this.isActiveFor(canvas)) {
                    ROI3DZShape.this.getShape2DROIOverlay().mouseMove(e, imagePoint, canvas);
                }
            } else {
                super.mouseMove(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (ROI3DZShape.this.isActiveFor(canvas)) {
                    ROI3DZShape.this.getShape2DROIOverlay().mouseDrag(e, imagePoint, canvas);
                }
            } else {
                super.mouseDrag(e, imagePoint, canvas);
            }
        }

        @Override
        public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (ROI3DZShape.this.isActiveFor(canvas)) {
                    ROI3DZShape.this.getShape2DROIOverlay().mousePressed(e, imagePoint, canvas);
                }
            } else {
                super.mousePressed(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (ROI3DZShape.this.isActiveFor(canvas)) {
                    ROI3DZShape.this.getShape2DROIOverlay().mouseReleased(e, imagePoint, canvas);
                }
            } else {
                super.mouseReleased(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (ROI3DZShape.this.isActiveFor(canvas)) {
                    ROI3DZShape.this.getShape2DROIOverlay().mouseClick(e, imagePoint, canvas);
                }
            } else {
                super.mouseClick(e, imagePoint, canvas);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (ROI3DZShape.this.isActiveFor(canvas)) {
                    ROI3DZShape.this.getShape2DROIOverlay().mouseWheelMoved(e, imagePoint, canvas);
                }
            } else {
                super.mouseWheelMoved(e, imagePoint, canvas);
            }
        }

        @Override
        public void drawROI(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                ROI3DZShape.this.getShape2DROIOverlay().drawROI(g, sequence, canvas);
            } else {
                super.drawROI(g, sequence, canvas);
            }
        }
    }
}

