/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import org.pushingpixels.flamingo.api.common.AsynchronousLoadListener;
import org.pushingpixels.flamingo.api.common.AsynchronousLoading;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class DecoratedResizableIcon
implements ResizableIcon,
AsynchronousLoading {
    protected ResizableIcon delegate;
    protected List<IconDecorator> decorators;

    public DecoratedResizableIcon(ResizableIcon delegate, IconDecorator ... decorators) {
        this.delegate = delegate;
        this.decorators = new ArrayList<IconDecorator>();
        if (decorators != null) {
            IconDecorator[] iconDecoratorArray = decorators;
            int n = decorators.length;
            int n2 = 0;
            while (n2 < n) {
                IconDecorator decorator = iconDecoratorArray[n2];
                this.decorators.add(decorator);
                ++n2;
            }
        }
    }

    public DecoratedResizableIcon(ResizableIcon delegate) {
        this(delegate, new IconDecorator[]{null});
    }

    @Override
    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.delegate.paintIcon(c, g, x, y);
        for (IconDecorator decorator : this.decorators) {
            decorator.paintIconDecoration(c, g, x, y, this.delegate.getIconWidth(), this.delegate.getIconHeight());
        }
    }

    @Override
    public void setDimension(Dimension newDimension) {
        this.delegate.setDimension(newDimension);
    }

    public void addIconDecorator(IconDecorator decorator) {
        if (this.decorators.contains(decorator)) {
            return;
        }
        this.decorators.add(decorator);
    }

    public void removeIconDecorator(IconDecorator decorator) {
        this.decorators.remove(decorator);
    }

    @Override
    public void addAsynchronousLoadListener(AsynchronousLoadListener l) {
        if (this.delegate instanceof AsynchronousLoading) {
            ((AsynchronousLoading)((Object)this.delegate)).addAsynchronousLoadListener(l);
        }
    }

    @Override
    public void removeAsynchronousLoadListener(AsynchronousLoadListener l) {
        if (this.delegate instanceof AsynchronousLoading) {
            ((AsynchronousLoading)((Object)this.delegate)).removeAsynchronousLoadListener(l);
        }
    }

    @Override
    public synchronized boolean isLoading() {
        if (this.delegate instanceof AsynchronousLoading && ((AsynchronousLoading)((Object)this.delegate)).isLoading()) {
            return true;
        }
        for (IconDecorator decorator : this.decorators) {
            if (!(decorator instanceof AsynchronousLoading) || !((AsynchronousLoading)((Object)decorator)).isLoading()) continue;
            return true;
        }
        return false;
    }

    public static interface IconDecorator {
        public void paintIconDecoration(Component var1, Graphics var2, int var3, int var4, int var5, int var6);
    }
}

