/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.process.process3D;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.collection.array.Array1DUtil;

/**
 * Utilities to transform <code>Sequence</code> objects to arrays.
 * 
 * @version May 3, 2014
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class SequenceToArrayConverter {

	// ============================================================================
	// PUBLIC METHODS

	/** Converts a binary <code>Sequence</code> to a <code>boolean</code> array. */
	public static boolean[][] sequenceToBinaryArray(Sequence seq) {
		Sequence singleChannelSequence = SequenceUtil.extractChannel(seq, 0);
		int width_ = singleChannelSequence.getWidth();
		int height_ = singleChannelSequence.getHeight();
		int depth_ = singleChannelSequence.getSizeZ();

		int frameLength = width_ * height_;
		boolean[][] binaryMask_ = new boolean[depth_][];
		for (int z = 0; z < depth_; z++) {
			IcyBufferedImage singleFrameImage = singleChannelSequence.getImage(
					0, z);
			double[] mask = Array1DUtil.arrayToDoubleArray(singleFrameImage
					.getDataXY(0), singleFrameImage.getDataType_().isSigned());

			binaryMask_[z] = new boolean[frameLength];
			for (int i = 0; i < frameLength; i++) {
				binaryMask_[z][i] = mask[i] != 0;
			}
		}
		return binaryMask_;
	}

	// ----------------------------------------------------------------------------

	/** Converts a <code>Sequence</code> to a <code>double</code> array. */
	public static double[][] sequenceToDoubleArray(Sequence seq) {
		Sequence singleChannelSequence = SequenceUtil.extractChannel(seq, 0);
		int depth_ = singleChannelSequence.getSizeZ();

		double[][] binaryMask_ = new double[depth_][];
		for (int z = 0; z < depth_; z++) {
			IcyBufferedImage singleFrameImage = singleChannelSequence.getImage(
					0, z);
			binaryMask_[z] = Array1DUtil.arrayToDoubleArray(singleFrameImage
					.getDataXY(0), singleFrameImage.getDataType_().isSigned());
		}
		return binaryMask_;
	}
}
