package plugins.vannary.morphomaths;

public class PixWatershed3D {

	private int offset;
	private int x;
	private int y;
	private int z;

	//-----------------------------------------
	//Constructors
	//-----------------------------------------
	public PixWatershed3D(int x, int y, int z, int width, int height){
		this.offset=x+y*width+z*width*height;
		this.x=x;
		this.y=y;
		this.z=z;
	}

	public PixWatershed3D(int offset, int z, int width ){
		this.offset=offset;
		this.x=offset%width;
		this.y=(int)Math.floor((double)offset/(double)width);
		this.z=z;
	}

	public int getOffset() {
		return offset;
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

	public int getZ(){
		return z;
	}

}