/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.shape.priorshapes.shapes;

import plugins.big.bigsnakeutils.icy.snake2D.Snake2DNode;

/**
 * Shape prior with taking the shape of a part of the white matter of the brain.
 * 
 * @version November 13, 2013
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class BrainWhite extends PriorShape {

	public BrainWhite() {
		name_ = new String("Brain white matter");
		minNumberNodes_ = 16;
		coef_ = new Snake2DNode[minNumberNodes_];
		coef_[0] = new Snake2DNode(703.0, 327.0);
		coef_[1] = new Snake2DNode(705.0, 258.0);
		coef_[2] = new Snake2DNode(671.0, 223.0);
		coef_[3] = new Snake2DNode(638.0, 155.0);
		coef_[4] = new Snake2DNode(672.0, 86.0);
		coef_[5] = new Snake2DNode(606.0, 155.0);
		coef_[6] = new Snake2DNode(542.0, 86.0);
		coef_[7] = new Snake2DNode(574.0, 155.0);
		coef_[8] = new Snake2DNode(542.0, 222.0);
		coef_[9] = new Snake2DNode(509.0, 258.0);
		coef_[10] = new Snake2DNode(508.0, 327.0);
		coef_[11] = new Snake2DNode(540.0, 292.0);
		coef_[12] = new Snake2DNode(573.0, 272.0);
		coef_[13] = new Snake2DNode(607.0, 259.0);
		coef_[14] = new Snake2DNode(638.0, 273.0);
		coef_[15] = new Snake2DNode(671.0, 294.0);
	}
}
