/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base.mapping;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public abstract class Mapping {
    protected final VectorSpace inputSpace;
    protected final VectorSpace outputSpace;

    protected Mapping(VectorSpace inp, VectorSpace out) {
        this.inputSpace = inp;
        this.outputSpace = out;
    }

    protected Mapping(VectorSpace space) {
        this.inputSpace = space;
        this.outputSpace = space;
    }

    public VectorSpace getInputSpace() {
        return this.inputSpace;
    }

    public VectorSpace getOutputSpace() {
        return this.outputSpace;
    }

    public boolean isEndomorphism() {
        return this.outputSpace == this.inputSpace;
    }

    public void apply(Vector dst, Vector src) throws IncorrectSpaceException {
        if (!this.outputSpace.owns(dst)) {
            throw new IncorrectSpaceException("Destination does not belong to the output space");
        }
        if (!this.inputSpace.owns(src)) {
            throw new IncorrectSpaceException("Source does not belong to the input space");
        }
        this._apply(dst, src);
    }

    protected abstract void _apply(Vector var1, Vector var2);
}

