/*
 * Decompiled with CFR 0.152.
 */
package mitiv.psf;

import java.util.Arrays;
import mitiv.array.ArrayFactory;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.DoubleArray;
import mitiv.array.Float2D;
import mitiv.array.Float3D;
import mitiv.array.FloatArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.FloatFunction;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.psf.PsfModel;
import mitiv.utils.FFTUtils;
import org.jtransforms.fft.DoubleFFT_1D;
import org.jtransforms.fft.DoubleFFT_2D;
import org.jtransforms.fft.FloatFFT_1D;
import org.jtransforms.fft.FloatFFT_2D;

public class MoffatPsf
extends PsfModel {
    double[] scale;
    double alpha;
    double beta;
    int rank;
    Object fft;

    public MoffatPsf(Shape psfShape, double alpha, double beta, double[] scale, boolean single) {
        block12: {
            block11: {
                super(psfShape, single);
                this.scale = null;
                this.alpha = alpha;
                this.beta = beta;
                this.rank = psfShape.rank();
                if (scale == null) {
                    scale = new double[this.rank];
                    Arrays.fill(scale, 1.0);
                } else if (this.rank != scale.length) {
                    throw new IllegalArgumentException("Scale and shape must have the same rank");
                }
                this.scale = Arrays.copyOf(scale, this.rank);
                if (!single) break block11;
                switch (this.rank) {
                    case 1: {
                        this.fft = new FloatFFT_1D(psfShape.dimension(0));
                        break block12;
                    }
                    case 2: {
                        this.fft = new FloatFFT_2D(psfShape.dimension(1), psfShape.dimension(0));
                        break block12;
                    }
                    default: {
                        throw new IllegalArgumentException("Rank >2 unsupported");
                    }
                }
            }
            switch (this.rank) {
                case 1: {
                    this.fft = new DoubleFFT_1D(psfShape.dimension(0));
                    break;
                }
                case 2: {
                    this.fft = new DoubleFFT_2D(psfShape.dimension(1), psfShape.dimension(0));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Rank >2 unsupported");
                }
            }
        }
    }

    private void computePsf() {
        this.psf = FFTUtils.fftDist(this.psfShape, this.scale);
        if (this.isSingle()) {
            this.psf = this.psf.toFloat();
            ((FloatArray)this.psf).map(new FloatMoffat(this.alpha, this.beta));
            ((FloatArray)this.psf).scale(1.0f / ((FloatArray)this.psf).sum());
        } else {
            this.psf = this.psf.toDouble();
            ((DoubleArray)this.psf).map(new DoubleMoffat(this.alpha, this.beta));
            ((DoubleArray)this.psf).scale(1.0 / ((DoubleArray)this.psf).sum());
        }
    }

    @Override
    public ShapedArray getPsf() {
        if (this.psf == null) {
            this.computePsf();
        }
        return this.psf;
    }

    @Override
    public ShapedArray getMtf() {
        ShapedArray mtf;
        block10: {
            Shape mtfShape;
            block9: {
                if (this.psf == null) {
                    this.computePsf();
                }
                int[] mtfdims = new int[this.rank + 1];
                System.arraycopy(this.psfShape.copyDimensions(), 0, mtfdims, 1, this.rank);
                mtfdims[0] = 2;
                mtfShape = new Shape(mtfdims);
                if (!this.isSingle()) break block9;
                mtf = ArrayFactory.create(4, mtfShape);
                switch (this.rank) {
                    case 1: {
                        ((Float2D)mtf).slice(0, 0).assign(this.psf);
                        ((FloatFFT_1D)this.fft).realForwardFull(((Float2D)mtf).getData());
                        break block10;
                    }
                    case 2: {
                        ((Float3D)mtf).slice(0, 0).assign(this.psf);
                        ((FloatFFT_2D)this.fft).realForwardFull(((Float3D)mtf).getData());
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Rank >2 unsupported");
                    }
                }
            }
            mtf = ArrayFactory.create(5, mtfShape);
            switch (this.rank) {
                case 1: {
                    ((Double2D)mtf).slice(0, 0).assign(this.psf);
                    ((DoubleFFT_1D)this.fft).realForwardFull(((Double2D)mtf).getData());
                    break;
                }
                case 2: {
                    ((Double3D)mtf).slice(0, 0).assign(this.psf);
                    ((DoubleFFT_2D)this.fft).realForwardFull(((Double3D)mtf).getData());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Rank >2 unsupported");
                }
            }
        }
        return mtf;
    }

    @Override
    public void setParam(DoubleShapedVector param) {
        this.setParam(param.getData());
    }

    @Override
    public void setParam(double[] x) {
        switch (x.length) {
            case 4: {
                this.scale[1] = x[3];
            }
            case 3: {
                this.scale[0] = x[2];
            }
            case 2: {
                this.beta = Math.abs(x[1]);
            }
            case 1: {
                this.alpha = Math.abs(x[0]);
            }
        }
        this.psf = null;
    }

    private class FloatMoffat
    implements FloatFunction {
        double alpha2 = 1.0;
        double beta = 1.0;
        double factor = 1.0;

        public FloatMoffat(double alph, double bet) {
            this.alpha2 = alph * alph;
            this.beta = bet;
            this.factor = (this.beta - 1.0) / this.alpha2;
        }

        @Override
        public float apply(float arg) {
            return (float)(this.factor * Math.pow(1.0 + (double)arg / this.alpha2, -this.beta));
        }
    }

    private class DoubleMoffat
    implements DoubleFunction {
        double alpha2 = 1.0;
        double beta = 1.0;
        double factor = 1.0;

        public DoubleMoffat(double alph, double bet) {
            this.alpha2 = alph * alph;
            this.beta = bet;
            this.factor = (this.beta - 1.0) / this.alpha2;
        }

        @Override
        public double apply(double arg) {
            return this.factor * Math.pow(1.0 + arg / this.alpha2, -this.beta);
        }
    }
}

