/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

import java.util.stream.IntStream;
import mitiv.array.ArrayFactory;
import mitiv.array.ByteArray;
import mitiv.array.DoubleArray;
import mitiv.array.FloatArray;
import mitiv.array.IntArray;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.base.mapping.ByteScanner;
import mitiv.base.mapping.DoubleScanner;
import mitiv.base.mapping.FloatScanner;
import mitiv.base.mapping.IntScanner;
import mitiv.base.mapping.LongScanner;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.linalg.shaped.ShapedVector;

public class Histogram {
    protected double vmin = Double.NaN;
    protected double vmax = Double.NaN;
    protected int[] histo = null;
    protected int nans = 0;
    protected int posinfs = 0;
    protected int neginfs = 0;
    protected int[] count = null;
    protected int nbin = 1;

    public double getMinimumValue() {
        return this.vmin;
    }

    public double getMaximumValue() {
        return this.vmax;
    }

    public int getNumberOfNaNs() {
        return this.nans;
    }

    public int getNumberOfPositiveInfinites() {
        return this.posinfs;
    }

    public int getNumberOfBins() {
        return this.nbin;
    }

    public Histogram() {
    }

    public Histogram(ShapedArray arr) {
        this.update(arr);
    }

    public Histogram(ShapedVector vec) {
        this.update(vec);
    }

    public Histogram reset() {
        this.vmin = Double.NaN;
        this.vmax = Double.NaN;
        this.histo = null;
        this.nans = 0;
        this.posinfs = 0;
        this.neginfs = 0;
        this.nbin = 1;
        this.count = null;
        return this;
    }

    public Histogram update(ShapedArray arr) {
        if (arr != null) {
            double tmpmax;
            double tmpmin;
            switch (arr.getType()) {
                case 0: {
                    int[] mm = ((ByteArray)arr).getMinAndMax();
                    tmpmin = mm[0];
                    tmpmax = mm[1];
                    break;
                }
                case 1: {
                    short[] mm = ((ShortArray)arr).getMinAndMax();
                    tmpmin = mm[0];
                    tmpmax = mm[1];
                    break;
                }
                case 2: {
                    int[] mm = ((IntArray)arr).getMinAndMax();
                    tmpmin = mm[0];
                    tmpmax = mm[1];
                    break;
                }
                case 3: {
                    long[] mm = ((LongArray)arr).getMinAndMax();
                    tmpmin = mm[0];
                    tmpmax = mm[1];
                    break;
                }
                case 4: {
                    float[] mm = ((FloatArray)arr).getMinAndMax();
                    tmpmin = mm[0];
                    tmpmax = mm[1];
                    break;
                }
                case 5: {
                    double[] mm = ((DoubleArray)arr).getMinAndMax();
                    tmpmin = mm[0];
                    tmpmax = mm[1];
                    break;
                }
                default: {
                    throw new IllegalTypeException("Unsupported element type");
                }
            }
            this.updateSize(tmpmin, tmpmax);
            if (arr != null) {
                switch (arr.getType()) {
                    case 0: {
                        ((ByteArray)arr).scan(new ByteHistogram());
                        break;
                    }
                    case 1: {
                        ((ShortArray)arr).scan(new ShortHistogram());
                        break;
                    }
                    case 2: {
                        ((IntArray)arr).scan(new IntHistogram());
                        break;
                    }
                    case 3: {
                        ((LongArray)arr).scan(new LongHistogram());
                        break;
                    }
                    case 4: {
                        ((FloatArray)arr).scan(new FloatHistogram());
                        break;
                    }
                    case 5: {
                        ((DoubleArray)arr).scan(new DoubleHistogram());
                        break;
                    }
                    default: {
                        throw new IllegalTypeException("Unsupported element type");
                    }
                }
            }
        }
        return this;
    }

    private void updateSize(double tmpmin, double tmpmax) {
        boolean updte = false;
        if (Double.isNaN(this.vmin) || this.vmin > tmpmin) {
            this.vmin = tmpmin;
            updte = true;
        }
        if (Double.isNaN(this.vmax) || this.vmax < tmpmax) {
            this.vmax = tmpmax;
            updte = true;
        }
        if (updte) {
            this.nbin = (int)(Math.ceil(this.vmax) - Math.floor(this.vmin)) + 1;
            if (this.count == null || this.histo == null) {
                this.count = new int[this.nbin];
                this.histo = IntStream.rangeClosed((int)Math.floor(this.vmin), (int)Math.ceil(this.vmax)).toArray();
            } else {
                int[] oldcount = (int[])this.count.clone();
                int first = (int)Math.floor(this.vmin) - this.histo[0];
                this.count = new int[this.nbin];
                this.histo = IntStream.rangeClosed((int)Math.floor(this.vmin), (int)Math.ceil(this.vmax)).toArray();
                for (int i = 0; i < oldcount.length; ++i) {
                    this.count[first + i] = oldcount[i];
                }
            }
        }
    }

    public Histogram update(ShapedVector vec) {
        return this.update(ArrayFactory.wrap(vec));
    }

    public Histogram compute(ShapedArray arr) {
        return this.reset().update(arr);
    }

    public Histogram compute(ShapedVector vec) {
        return this.reset().update(vec);
    }

    public void Show() {
        System.out.format(" Histogram :\n", new Object[0]);
        if (this.count != null) {
            for (int j = 0; j < this.count.length; ++j) {
                System.out.format("  %d \t %d \n", this.histo[j], this.count[j]);
            }
        }
    }

    private class DoubleHistogram
    implements DoubleScanner {
        private DoubleHistogram() {
        }

        @Override
        public void initialize(double arg) {
            this.update(arg);
        }

        @Override
        public void update(double val) {
            if (Double.isNaN(val)) {
                ++Histogram.this.nans;
            } else if (Double.isInfinite(val)) {
                if (val > 0.0) {
                    ++Histogram.this.posinfs;
                } else {
                    ++Histogram.this.neginfs;
                }
            } else {
                int idx;
                int n = idx = (int)Math.floor(val) - Histogram.this.histo[0];
                Histogram.this.count[n] = Histogram.this.count[n] + 1;
            }
        }
    }

    private class FloatHistogram
    implements FloatScanner {
        private FloatHistogram() {
        }

        @Override
        public void initialize(float arg) {
            this.update(arg);
        }

        @Override
        public void update(float val) {
            if (Float.isNaN(val)) {
                ++Histogram.this.nans;
            } else if (Float.isInfinite(val)) {
                if (val > 0.0f) {
                    ++Histogram.this.posinfs;
                } else {
                    ++Histogram.this.neginfs;
                }
            } else {
                int idx;
                int n = idx = (int)Math.floor(val) - Histogram.this.histo[0];
                Histogram.this.count[n] = Histogram.this.count[n] + 1;
            }
        }
    }

    private class LongHistogram
    implements LongScanner {
        private LongHistogram() {
        }

        @Override
        public void initialize(long arg) {
            this.update(arg);
        }

        @Override
        public void update(long val) {
            int idx;
            int n = idx = (int)Math.floor(val) - Histogram.this.histo[0];
            Histogram.this.count[n] = Histogram.this.count[n] + 1;
        }
    }

    private class IntHistogram
    implements IntScanner {
        private IntHistogram() {
        }

        @Override
        public void initialize(int arg) {
            this.update(arg);
        }

        @Override
        public void update(int val) {
            int idx;
            int n = idx = (int)Math.floor(val) - Histogram.this.histo[0];
            Histogram.this.count[n] = Histogram.this.count[n] + 1;
        }
    }

    private class ShortHistogram
    implements ShortScanner {
        private ShortHistogram() {
        }

        @Override
        public void initialize(short arg) {
            this.update(arg);
        }

        @Override
        public void update(short val) {
            int idx;
            int n = idx = (int)Math.floor(val) - Histogram.this.histo[0];
            Histogram.this.count[n] = Histogram.this.count[n] + 1;
        }
    }

    private class ByteHistogram
    implements ByteScanner {
        private ByteHistogram() {
        }

        @Override
        public void initialize(byte arg) {
            this.update(arg);
        }

        @Override
        public void update(byte val) {
            int idx;
            int n = idx = (int)Math.floor(val) - Histogram.this.histo[0];
            Histogram.this.count[n] = Histogram.this.count[n] + 1;
        }
    }
}

