/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.detector;

import icy.image.IcyBufferedImage;
import icy.type.collection.array.Array1DUtil;
import java.util.ArrayList;
import java.util.Arrays;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.Point3D;

public class LocalMaximaDetector {
    private IcyBufferedImage image;
    private boolean[] consideredMA;
    private int width;
    private int height;
    private double distance;
    private boolean[] consideredMax;
    public ArrayList<double[]> maxima;
    private ArrayList<double[]> maximaToSeparate;
    int numMax;

    public LocalMaximaDetector(IcyBufferedImage image, double distance) {
        this.image = image;
        this.numMax = 0;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.consideredMA = new boolean[this.width * this.height];
        Arrays.fill(this.consideredMA, false);
        this.distance = distance;
    }

    public LocalMaximaDetector(IcyBufferedImage image) {
        this(image, 10.0);
    }

    public void detectLocalMaxima() {
        this.detectLocalMaxima(2.0);
    }

    public int getNumMax() {
        return this.maxima.size();
    }

    public void detectLocalMaxima(double minDist) {
        this.maxima = new ArrayList(50);
        double[] results = Array1DUtil.arrayToDoubleArray((Object)this.image.getDataXY(0), (boolean)this.image.isSignedDataType());
        for (int j = 0; j < this.image.getHeight(); ++j) {
            for (int i = 0; i < this.image.getWidth(); ++i) {
                if (!this.consideredMA[j * this.width + i]) {
                    this.consideredMA[j * this.width + i] = true;
                    if (!this.isMax18connex2D(results, i, j)) continue;
                    this.maxima.add(new double[]{i, j, 0.0});
                    ++this.numMax;
                    continue;
                }
                this.explore18connex2D(results, i, j);
            }
        }
        ArrayList maximaCopy = (ArrayList)this.maxima.clone();
        double dist2 = minDist * minDist;
        for (int i = 0; i < this.maxima.size(); ++i) {
            double[] coord1 = (double[])maximaCopy.get(i);
            for (int j = i + 1; j < this.maxima.size(); ++j) {
                double[] coord2 = (double[])maximaCopy.get(j);
                if (!(Math.pow(coord1[0] - coord2[0], 2.0) + Math.pow(coord1[1] - coord2[1], 2.0) < dist2)) continue;
                if (results[(int)Math.round(coord1[1]) * this.width + (int)Math.round(coord1[0]) + 1] > results[(int)Math.round(coord2[1]) * this.width + (int)Math.round(coord2[0]) + 1]) {
                    this.maxima.remove(coord2);
                    continue;
                }
                this.maxima.remove(coord1);
            }
        }
        this.maximaToSeparate = this.maxima;
    }

    public ArrayList<DetectionSpot> getMaximaAsSpots(int t) {
        ArrayList<DetectionSpot> spots = new ArrayList<DetectionSpot>(this.maxima.size());
        for (double[] max : this.maxima) {
            DetectionSpot spot = new DetectionSpot();
            ArrayList<Point3D> points = new ArrayList<Point3D>();
            Point3D point = new Point3D(max);
            points.add(point);
            spot.points = points;
            spot.computeMassCenter();
            spot.setT(t);
            spots.add(spot);
        }
        return spots;
    }

    protected boolean isMax18connex2D(double[] results, int i, int j) {
        double val = results[j * this.width + i];
        boolean max = true;
        if (i < this.width - 1) {
            if (val <= results[j * this.width + i + 1]) {
                max = false;
            } else {
                this.consideredMA[j * this.width + (i + 1)] = true;
            }
            if (j < this.height - 1) {
                if (val <= results[(j + 1) * this.width + i + 1]) {
                    max = false;
                } else {
                    this.consideredMA[(j + 1) * this.width + (i + 1)] = true;
                }
            }
        }
        if (j < this.height - 1) {
            if (val <= results[(j + 1) * this.width + i]) {
                max = false;
            } else {
                this.consideredMA[(j + 1) * this.width + i] = true;
            }
            if (i > 0) {
                if (val <= results[(j + 1) * this.width + i - 1]) {
                    max = false;
                } else {
                    this.consideredMA[(j + 1) * this.width + i - 1] = true;
                }
            }
        }
        return max;
    }

    protected void explore18connex2D(double[] results, int i, int j) {
        double val = results[j * this.width + i];
        if (i < this.width - 1) {
            if (val >= results[j * this.width + i + 1]) {
                this.consideredMA[j * this.width + (i + 1)] = true;
            }
            if (j < this.height - 1 && val >= results[(j + 1) * this.width + (i + 1)]) {
                this.consideredMA[(j + 1) * this.width + (i + 1)] = true;
            }
        }
        if (j < this.height - 1) {
            if (val >= results[(j + 1) * this.width + i]) {
                this.consideredMA[(j + 1) * this.width + i] = true;
            }
            if (i > 0 && val >= results[(j + 1) * this.width + i - 1]) {
                this.consideredMA[(j + 1) * this.width + i - 1] = true;
            }
        }
    }
}

