/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.detector;

import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class UDWTScale
implements CaretListener {
    JPanel scalePanel;
    JTextField sensitivityTextField;
    JCheckBox enabledCheckBox;
    public int scaleNumber;

    public UDWTScale(int scaleNumber, boolean enabled, double threshold) {
        this.scaleNumber = scaleNumber;
        this.enabledCheckBox = new JCheckBox("Scale " + scaleNumber, enabled);
        this.sensitivityTextField = new JTextField("" + threshold);
        this.sensitivityTextField.addCaretListener(this);
        JLabel descriptionLabel = new JLabel("");
        ComponentUtil.setFixedSize((Component)this.sensitivityTextField, (Dimension)new Dimension(60, 22));
        ComponentUtil.setFixedSize((Component)descriptionLabel, (Dimension)new Dimension(80, 22));
        ComponentUtil.setFixedSize((Component)this.enabledCheckBox, (Dimension)new Dimension(80, 22));
        switch (scaleNumber) {
            case 1: {
                descriptionLabel.setText("~1 pixel");
                break;
            }
            case 2: {
                descriptionLabel.setText("~3 pixels");
                break;
            }
            case 3: {
                descriptionLabel.setText("~7 pixels");
                break;
            }
            case 4: {
                descriptionLabel.setText("~13 pixels");
                break;
            }
            case 5: {
                descriptionLabel.setText("~25 pixels");
            }
        }
        this.scalePanel = new JPanel();
        this.scalePanel.setLayout(new BoxLayout(this.scalePanel, 3));
        this.scalePanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.enabledCheckBox, this.sensitivityTextField, Box.createHorizontalStrut(20), descriptionLabel, Box.createHorizontalGlue()}));
    }

    public JPanel getPanel() {
        return this.scalePanel;
    }

    public void setThreshold(double threshold) {
        this.sensitivityTextField.setText("" + threshold);
    }

    public double getThreshold() {
        double threshold;
        try {
            threshold = Double.parseDouble(this.sensitivityTextField.getText());
        }
        catch (NumberFormatException nfe) {
            threshold = 0.0;
        }
        return threshold;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.getThreshold();
    }

    public boolean isEnabled() {
        return this.enabledCheckBox.isSelected();
    }

    public static JPanel getHeaderPanel() {
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new BoxLayout(headerPanel, 3));
        JLabel scaleLabel = new JLabel("Scale enabled");
        ComponentUtil.setFixedSize((Component)scaleLabel, (Dimension)new Dimension(80, 22));
        JLabel thresholdLabel = new JLabel("Sensitivity");
        ComponentUtil.setFixedSize((Component)thresholdLabel, (Dimension)new Dimension(80, 22));
        JLabel objectSizeLabel = new JLabel("Object size");
        ComponentUtil.setFixedSize((Component)objectSizeLabel, (Dimension)new Dimension(80, 22));
        headerPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{scaleLabel, thresholdLabel, objectSizeLabel, Box.createHorizontalGlue()}));
        return headerPanel;
    }
}

