/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.UIManager;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.flamingo.internal.utils.KeyTipManager;

public class KeyTipRenderingUtilities {
    private static int INSETS = 3;

    public static Dimension getPrefSize(FontMetrics fm, String keyTip) {
        int prefWidth = fm.stringWidth(keyTip) + 2 * INSETS + 1;
        int prefHeight = fm.getHeight() + INSETS - 1;
        return new Dimension(prefWidth, prefHeight);
    }

    public static void renderKeyTip(Graphics g, Container c, Rectangle rect, String keyTip, boolean toPaintEnabled) {
        CellRendererPane buttonRendererPane = new CellRendererPane();
        JButton rendererButton = new JButton("");
        rendererButton.setEnabled(toPaintEnabled);
        buttonRendererPane.setBounds(rect.x, rect.y, rect.width, rect.height);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(AlphaComposite.SrcOver.derive(toPaintEnabled ? 1.0f : 0.5f));
        Shape clip = g2d.getClip();
        RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(rect.x, rect.y, rect.width - 1, rect.height - 1, 6.0, 6.0);
        g2d.clip(roundRect);
        buttonRendererPane.paintComponent(g2d, rendererButton, c, rect.x - rect.width / 2, rect.y - rect.height / 2, 2 * rect.width, 2 * rect.height, true);
        g2d.setClip(clip);
        g2d.setColor(FlamingoUtilities.getBorderColor());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.draw(roundRect);
        g2d.setColor(FlamingoUtilities.getColor(Color.black, "Button.foreground"));
        Font font = UIManager.getFont("Button.font");
        font = font.deriveFont((float)font.getSize() + 1.0f);
        g2d.setFont(font);
        int strWidth = g2d.getFontMetrics().stringWidth(keyTip);
        g2d.translate(rect.x, rect.y);
        LineMetrics lineMetrics = g2d.getFontMetrics().getLineMetrics(keyTip, g2d);
        int strHeight = (int)lineMetrics.getHeight();
        g2d.drawString(keyTip, (rect.width - strWidth + 1) / 2, (rect.height + strHeight) / 2 - g2d.getFontMetrics().getDescent() + 1);
        g2d.dispose();
    }

    public static void renderMenuButtonKeyTips(Graphics g, JCommandMenuButton menuButton, CommandButtonLayoutManager layoutManager) {
        Dimension pref;
        Collection<KeyTipManager.KeyTipLink> currLinks = KeyTipManager.defaultManager().getCurrentlyShownKeyTips();
        if (currLinks == null) {
            return;
        }
        boolean found = false;
        for (KeyTipManager.KeyTipLink link : currLinks) {
            boolean bl = found = link.comp == menuButton;
            if (found) break;
        }
        if (!found) {
            return;
        }
        String actionKeyTip = menuButton.getActionKeyTip();
        String popupKeyTip = menuButton.getPopupKeyTip();
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = layoutManager.getLayoutInfo(menuButton, g);
        Point prefCenter = menuButton.getUI().getKeyTipAnchorCenterPoint();
        if (layoutInfo.iconRect.width > 0 && actionKeyTip != null) {
            pref = KeyTipRenderingUtilities.getPrefSize(g.getFontMetrics(), actionKeyTip);
            KeyTipRenderingUtilities.renderKeyTip(g, menuButton, new Rectangle(prefCenter.x - pref.width / 2, Math.min(prefCenter.y - pref.height / 2, layoutInfo.actionClickArea.y + layoutInfo.actionClickArea.height - pref.height), pref.width, pref.height), actionKeyTip, menuButton.getActionModel().isEnabled());
        }
        if (layoutInfo.popupClickArea.width > 0 && popupKeyTip != null) {
            pref = KeyTipRenderingUtilities.getPrefSize(g.getFontMetrics(), popupKeyTip);
            if (menuButton.getPopupOrientationKind() == JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD) {
                if (menuButton.getCommandButtonKind() != JCommandButton.CommandButtonKind.POPUP_ONLY) {
                    KeyTipRenderingUtilities.renderKeyTip(g, menuButton, new Rectangle(layoutInfo.popupClickArea.x + layoutInfo.popupClickArea.width - pref.width - 4, Math.min(prefCenter.y - pref.height / 2, layoutInfo.actionClickArea.y + layoutInfo.actionClickArea.height - pref.height), pref.width, pref.height), popupKeyTip, menuButton.getPopupModel().isEnabled());
                } else {
                    KeyTipRenderingUtilities.renderKeyTip(g, menuButton, new Rectangle(prefCenter.x - pref.width / 2, Math.min(prefCenter.y - pref.height / 2, layoutInfo.popupClickArea.y + layoutInfo.popupClickArea.height - pref.height), pref.width, pref.height), popupKeyTip, menuButton.getPopupModel().isEnabled());
                }
            } else {
                KeyTipRenderingUtilities.renderKeyTip(g, menuButton, new Rectangle((layoutInfo.popupClickArea.x + layoutInfo.popupClickArea.width - pref.width) / 2, layoutInfo.popupClickArea.y + layoutInfo.popupClickArea.height - pref.height, pref.width, pref.height), popupKeyTip, menuButton.getPopupModel().isEnabled());
            }
        }
    }
}

