/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.utils;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.DefaultButtonModel;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.flamingo.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class RibbonApplicationMenuButtonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> imageCache = new LazyResettableHashMap("Substance.Flamingo.RibbonApplicationMenuButtonBackgroundDelegate");

    public static BufferedImage getFullAlphaBackground(JRibbonApplicationMenuButton menuButton, SubstanceFillPainter painter, SubstanceBorderPainter borderPainter, int width, int height) {
        JRibbon ribbon = menuButton.getRibbon();
        DefaultButtonModel model = new DefaultButtonModel();
        model.setEnabled(true);
        model.setSelected(menuButton.getPopupModel().isSelected());
        boolean popupShowing = menuButton.getPopupModel().isPopupShowing();
        model.setRollover(menuButton.getPopupModel().isRollover() && !popupShowing);
        model.setPressed(menuButton.getPopupModel().isPressed() || popupShowing);
        model.setArmed(menuButton.getActionModel().isArmed() || popupShowing);
        ActionPopupTransitionAwareUI ui = (ActionPopupTransitionAwareUI)((Object)menuButton.getUI());
        StateTransitionTracker popupStateTransitionTracker = ui.getPopupTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = popupStateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        ComponentState currState = ComponentState.getState(model, menuButton);
        SubstanceColorScheme baseFillScheme = SubstanceColorSchemeUtilities.getColorScheme(menuButton, currState);
        SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(ribbon, ColorSchemeAssociationKind.BORDER, currState);
        HashMapKey baseKey = SubstanceCoreUtilities.getHashKey(width, height, baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), painter.getDisplayName(), borderPainter.getDisplayName(), SubstanceSizeUtils.getComponentFontSize(menuButton));
        BufferedImage baseLayer = imageCache.get(baseKey);
        if (baseLayer == null) {
            baseLayer = RibbonApplicationMenuButtonBackgroundDelegate.getSingleLayer(menuButton, painter, borderPainter, width, height, baseFillScheme, baseBorderScheme);
            imageCache.put(baseKey, baseLayer);
        }
        if (popupShowing || currState.isDisabled() || activeStates.size() == 1) {
            return baseLayer;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage((Image)baseLayer, 0, 0, null);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float contribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(menuButton, activeState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(ribbon, ColorSchemeAssociationKind.BORDER, activeState);
            HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, fillScheme.getDisplayName(), borderScheme.getDisplayName(), painter.getDisplayName(), borderPainter.getDisplayName(), SubstanceSizeUtils.getComponentFontSize(menuButton));
            BufferedImage layer = imageCache.get(key);
            if (layer == null) {
                layer = RibbonApplicationMenuButtonBackgroundDelegate.getSingleLayer(menuButton, painter, borderPainter, width, height, fillScheme, borderScheme);
                imageCache.put(key, layer);
            }
            g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
            g2d.drawImage((Image)layer, 0, 0, null);
        }
        g2d.dispose();
        return result;
    }

    private static BufferedImage getSingleLayer(JRibbonApplicationMenuButton menuButton, SubstanceFillPainter painter, SubstanceBorderPainter borderPainter, int width, int height, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme) {
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(menuButton)) / 2.0);
        int outerRadius = Math.min(width - 2 * borderDelta - 2, height - 2 * borderDelta - 2);
        int delta = outerRadius % 2 == 1 ? 1 : 0;
        Ellipse2D.Double contour = new Ellipse2D.Double(borderDelta + delta, borderDelta + delta, outerRadius - delta, outerRadius - delta);
        BufferedImage newBackground = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D finalGraphics = (Graphics2D)newBackground.getGraphics();
        painter.paintContourBackground(finalGraphics, menuButton, width, height, contour, false, fillScheme, true);
        int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(menuButton));
        int innerRadius = Math.min(width - 2 * (borderDelta + borderThickness) - 2, height - 2 * (borderDelta + borderThickness) - 2);
        delta = innerRadius % 2 == 1 ? 1 : 0;
        Ellipse2D.Double contourInner = new Ellipse2D.Double(borderDelta + borderThickness + delta, borderDelta + borderThickness + delta, innerRadius - delta, innerRadius - delta);
        borderPainter.paintBorder(finalGraphics, menuButton, width, height, contour, contourInner, borderScheme);
        return newBackground;
    }
}

