/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.usermodel;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import loci.poi.ddf.EscherBSERecord;
import loci.poi.hssf.usermodel.HSSFAnchor;
import loci.poi.hssf.usermodel.HSSFClientAnchor;
import loci.poi.hssf.usermodel.HSSFPatriarch;
import loci.poi.hssf.usermodel.HSSFShape;
import loci.poi.hssf.usermodel.HSSFSimpleShape;
import loci.poi.util.POILogFactory;
import loci.poi.util.POILogger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HSSFPicture
extends HSSFSimpleShape {
    public static final int PICTURE_TYPE_EMF = 2;
    public static final int PICTURE_TYPE_WMF = 3;
    public static final int PICTURE_TYPE_PICT = 4;
    public static final int PICTURE_TYPE_JPEG = 5;
    public static final int PICTURE_TYPE_PNG = 6;
    public static final int PICTURE_TYPE_DIB = 7;
    int pictureIndex;
    HSSFPatriarch patriarch;
    private static final POILogger log = POILogFactory.getLogger(HSSFPicture.class);

    HSSFPicture(HSSFShape parent, HSSFAnchor anchor) {
        super(parent, anchor);
        this.setShapeType(8);
    }

    public int getPictureIndex() {
        return this.pictureIndex;
    }

    public void setPictureIndex(int pictureIndex) {
        this.pictureIndex = pictureIndex;
    }

    public void resize() {
        HSSFClientAnchor anchor = (HSSFClientAnchor)this.getAnchor();
        anchor.setAnchorType(2);
        HSSFClientAnchor pref = this.getPreferredSize();
        int row2 = anchor.getRow1() + (pref.getRow2() - pref.getRow1());
        int col2 = anchor.getCol1() + (pref.getCol2() - pref.getCol1());
        anchor.setCol2((short)col2);
        anchor.setDx1(0);
        anchor.setDx2(pref.getDx2());
        anchor.setRow2(row2);
        anchor.setDy1(0);
        anchor.setDy2(pref.getDy2());
    }

    public HSSFClientAnchor getPreferredSize() {
        HSSFClientAnchor anchor = new HSSFClientAnchor();
        EscherBSERecord bse = this.patriarch.sheet.book.getBSERecord(this.pictureIndex);
        byte[] data = bse.getBlipRecord().getPicturedata();
        byte type = bse.getBlipTypeWin32();
        switch (type) {
            case 5: 
            case 6: {
                BufferedImage img = null;
                ImageReader r = null;
                try {
                    ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
                    Iterator<ImageReader> i = ImageIO.getImageReaders(iis);
                    r = i.next();
                    r.setInput(iis);
                    img = r.read(0);
                    int[] dpi = this.getResolution(r);
                    int imgWidth = img.getWidth() * 96 / dpi[0];
                    int imgHeight = img.getHeight() * 96 / dpi[1];
                    int cellwidth = 64;
                    int rowheight = 17;
                    int col2 = imgWidth / cellwidth;
                    int row2 = imgHeight / rowheight;
                    int dx2 = (int)((float)(imgWidth % cellwidth) / (float)cellwidth * 1024.0f);
                    int dy2 = (int)((float)(imgHeight % rowheight) / (float)rowheight * 256.0f);
                    anchor.setCol2((short)col2);
                    anchor.setDx2(dx2);
                    anchor.setRow2(row2);
                    anchor.setDy2(dy2);
                    break;
                }
                catch (IOException e) {
                    log.log(5, e);
                    img = null;
                }
            }
        }
        return anchor;
    }

    protected int[] getResolution(ImageReader r) throws IOException {
        int hdpi = 96;
        int vdpi = 96;
        double mm2inch = 25.4;
        Element node = (Element)r.getImageMetadata(0).getAsTree("javax_imageio_1.0");
        NodeList lst = node.getElementsByTagName("HorizontalPixelSize");
        if (lst != null && lst.getLength() == 1) {
            hdpi = (int)(mm2inch / (double)Float.parseFloat(((Element)lst.item(0)).getAttribute("value")));
        }
        if ((lst = node.getElementsByTagName("VerticalPixelSize")) != null && lst.getLength() == 1) {
            vdpi = (int)(mm2inch / (double)Float.parseFloat(((Element)lst.item(0)).getAttribute("value")));
        }
        return new int[]{hdpi, vdpi};
    }
}

