/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentTypeEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExperimentTypeEnumHandler.class);
    private static final Hashtable<String, String> patterns = ExperimentTypeEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*FP\\s*", "FP");
        p.put("^\\s*FRET\\s*", "FRET");
        p.put("^\\s*TimeLapse\\s*", "TimeLapse");
        p.put("^\\s*FourDPlus\\s*", "FourDPlus");
        p.put("^\\s*Screen\\s*", "Screen");
        p.put("^\\s*Immunocytochemistry\\s*", "Immunocytochemistry");
        p.put("^\\s*Immunofluorescence\\s*", "Immunofluorescence");
        p.put("^\\s*FISH\\s*", "FISH");
        p.put("^\\s*Electrophysiology\\s*", "Electrophysiology");
        p.put("^\\s*IonImaging\\s*", "IonImaging");
        p.put("^\\s*Colocalization\\s*", "Colocalization");
        p.put("^\\s*PGIDocumentation\\s*", "PGIDocumentation");
        p.put("^\\s*FluorescenceLifetime\\s*", "FluorescenceLifetime");
        p.put("^\\s*SpectralImaging\\s*", "SpectralImaging");
        p.put("^\\s*Photobleaching\\s*", "Photobleaching");
        p.put("^\\s*SPIM\\s*", "SPIM");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return ExperimentType.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"ExperimentType", (Object)value);
        return ExperimentType.OTHER;
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return ExperimentType.class;
    }
}

