/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;

public class Dimensions {
    private Dimensions() {
    }

    public static Section makeSectionFromDimensions(Iterable<Dimension> dimensions) {
        try {
            ArrayList<Range> list = new ArrayList<Range>();
            for (Dimension d : dimensions) {
                int len = d.getLength();
                if (len > 0) {
                    list.add(new Range(d.getShortName(), 0, len - 1));
                    continue;
                }
                if (len == 0) {
                    list.add(Range.EMPTY);
                    continue;
                }
                assert (d.isVariableLength());
                list.add(Range.VLEN);
            }
            return new Section(list).makeImmutable();
        }
        catch (InvalidRangeException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static int[] makeShape(Iterable<Dimension> dimensions) {
        return Dimensions.makeSectionFromDimensions(dimensions).getShape();
    }

    public static String makeDimensionsString(List<Dimension> dimensions) {
        if (dimensions == null) {
            return "";
        }
        Formatter buf = new Formatter();
        for (int i = 0; i < dimensions.size(); ++i) {
            Dimension myd = dimensions.get(i);
            String dimName = myd.getShortName();
            if (i != 0) {
                buf.format(" ", new Object[0]);
            }
            if (myd.isVariableLength()) {
                buf.format("*", new Object[0]);
                continue;
            }
            if (myd.isShared()) {
                buf.format("%s", dimName);
                continue;
            }
            buf.format("%d", myd.getLength());
        }
        return buf.toString();
    }

    public static ImmutableList<Dimension> makeDimensionsList(Find finder, String dimString) throws IllegalArgumentException {
        if (dimString == null) {
            return ImmutableList.of();
        }
        if ((dimString = dimString.trim()).isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder newDimensions = ImmutableList.builder();
        StringTokenizer stoke = new StringTokenizer(dimString);
        while (stoke.hasMoreTokens()) {
            String dimName = stoke.nextToken();
            Dimension d = dimName.equals("*") ? Dimension.VLEN : finder.findByName(dimName);
            if (d == null) {
                try {
                    int len = Integer.parseInt(dimName);
                    d = Dimension.builder().setLength(len).setIsShared(false).build();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Dimension " + dimName + " does not exist");
                }
            }
            newDimensions.add(d);
        }
        return newDimensions.build();
    }

    public static ImmutableList<Dimension> makeDimensionsAnon(int[] shape) {
        if (shape == null || shape.length == 0) {
            return ImmutableList.of();
        }
        ImmutableList.Builder newDimensions = ImmutableList.builder();
        for (int len : shape) {
            newDimensions.add(Dimension.builder().setIsVariableLength(len == -1).setLength(len).setIsShared(false).build());
        }
        return newDimensions.build();
    }

    public static ImmutableList<Dimension> makeDimensionsAll(Variable v) {
        ImmutableList.Builder<Dimension> dimsAll = ImmutableList.builder();
        Dimensions.addDimensionsAll(dimsAll, v);
        return dimsAll.build();
    }

    private static void addDimensionsAll(ImmutableList.Builder<Dimension> result, Variable v) {
        if (v.isMemberOfStructure()) {
            Dimensions.addDimensionsAll(result, v.getParentStructure());
        }
        for (int i = 0; i < v.getRank(); ++i) {
            result.add((Object)v.getDimension(i));
        }
    }

    public static interface Find {
        @Nullable
        public Dimension findByName(String var1);
    }
}

