/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import javax.vecmath.Point3f;
import mcib3d.geom.Point3D;

public class Voxel3D
extends Point3D
implements Comparable<Voxel3D> {
    public double value;

    public Voxel3D() {
        this.value = Double.NaN;
    }

    public Voxel3D(int x, int y, int z, float val) {
        super(x, y, z);
        this.value = val;
    }

    public Voxel3D(int x, int y, int z, double val) {
        super(x, y, z);
        this.value = val;
    }

    public Voxel3D(double x, double y, double z, double val) {
        super(x, y, z);
        this.value = val;
    }

    public Voxel3D(Voxel3D vox) {
        super(vox.getX(), vox.getY(), vox.getZ());
        this.value = vox.getValue();
    }

    public Voxel3D(Point3f P, double val) {
        super(P.x, P.y, P.z);
        this.value = val;
    }

    public Voxel3D(Point3D P, double val) {
        super(P);
        this.value = val;
    }

    public void setVoxel(int x, int y, int z, float value) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.value = value;
    }

    public void setVoxel(int x, int y, int z, double value) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.value = (float)value;
    }

    public void setVoxel(double x, double y, double z, double value) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.value = (float)value;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "(" + this.getX() + " , " + this.getY() + " , " + this.getZ() + ")";
    }

    public void setValue(double val) {
        this.value = val;
    }

    public int getXYCoord(int sizeX) {
        return (int)(this.x + 0.5) + (int)(this.y + 0.5) * sizeX;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Voxel3D) {
            Voxel3D other = (Voxel3D)o;
            return other.x == this.x && other.y == this.y && other.z == this.z;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 31 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 31 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return hash;
    }

    @Override
    public int compareTo(Voxel3D v) {
        if (v.x == this.x && v.y == this.y && v.z == this.z) {
            return 0;
        }
        if (this.value < v.value) {
            return 1;
        }
        if (this.value > v.value) {
            return -1;
        }
        return 0;
    }
}

