/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Object3D_IJUtils;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;

public class ImageLabeller {
    HashMap<Integer, Spot> spots = null;
    int[][] labels;
    boolean debug = false;
    int minSize = 0;
    int maxsize = Integer.MAX_VALUE;
    ImageHandler currentMask = null;

    public ImageLabeller(boolean debug) {
        this.debug = debug;
    }

    public ImageLabeller() {
    }

    public ImageLabeller(int min, int max) {
        this.minSize = min;
        this.maxsize = max;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    public int getMaxsize() {
        return this.maxsize;
    }

    public void setMaxsize(int maxsize) {
        this.maxsize = maxsize;
    }

    private void labelSpots6(ImageHandler mask) {
        this.currentMask = mask;
        this.labels = new int[mask.sizeZ][mask.sizeXY];
        int sizeX = mask.sizeX;
        this.spots = new HashMap();
        int currentLabel = 1;
        if (this.debug) {
            System.out.println("Labelling...");
        }
        for (int z = 0; z < mask.sizeZ; ++z) {
            for (int y = 0; y < mask.sizeY; ++y) {
                for (int x = 0; x < sizeX; ++x) {
                    int nextLabel;
                    int xy = x + y * sizeX;
                    if (mask.getPixel(xy, z) == 0.0f) continue;
                    Spot currentSpot = null;
                    Vox3D v = new Vox3D(xy, z);
                    if (x > 0 && (nextLabel = this.labels[z][xy - 1]) != 0) {
                        if (currentSpot == null) {
                            currentSpot = this.spots.get(nextLabel);
                            currentSpot.addVox(v);
                        } else if (nextLabel != currentSpot.label) {
                            currentSpot = currentSpot.fusion(this.spots.get(nextLabel));
                            currentSpot.addVox(v);
                        }
                    }
                    if (y > 0 && (nextLabel = this.labels[z][xy - sizeX]) != 0) {
                        if (currentSpot == null) {
                            currentSpot = this.spots.get(nextLabel);
                            currentSpot.addVox(v);
                        } else if (nextLabel != currentSpot.label) {
                            currentSpot = currentSpot.fusion(this.spots.get(nextLabel));
                            currentSpot.addVox(v);
                        }
                    }
                    if (z > 0 && (nextLabel = this.labels[z - 1][xy]) != 0) {
                        if (currentSpot == null) {
                            currentSpot = this.spots.get(nextLabel);
                            currentSpot.addVox(v);
                        } else if (nextLabel != currentSpot.label) {
                            currentSpot = currentSpot.fusion(this.spots.get(nextLabel));
                            currentSpot.addVox(v);
                        }
                    }
                    if (currentSpot != null) continue;
                    this.spots.put(currentLabel, new Spot(currentLabel++, v));
                }
            }
        }
    }

    private void labelSpots26(ImageHandler mask) {
        this.currentMask = mask;
        this.labels = new int[mask.sizeZ][mask.sizeXY];
        int sizeX = mask.sizeX;
        this.spots = new HashMap();
        int currentLabel = 1;
        if (this.debug) {
            System.out.println("Labelling...");
        }
        for (int z = 0; z < mask.sizeZ; ++z) {
            for (int y = 0; y < mask.sizeY; ++y) {
                for (int x = 0; x < sizeX; ++x) {
                    int xy = x + y * sizeX;
                    if (mask.getPixel(xy, z) == 0.0f) continue;
                    Spot currentSpot = null;
                    Vox3D v = new Vox3D(xy, z);
                    for (int k = -1; k <= 1; ++k) {
                        for (int j = -1; j <= 1; ++j) {
                            for (int i = -1; i <= 1; ++i) {
                                int nextLabel;
                                if (!mask.contains(x + i, y + j, z + k) || i * i + j * j + k * k == 0 || i >= 0 && j >= 0 && k >= 0 || (nextLabel = this.labels[z + k][xy + i + j * sizeX]) == 0) continue;
                                if (currentSpot == null) {
                                    currentSpot = this.spots.get(nextLabel);
                                    currentSpot.addVox(v);
                                    continue;
                                }
                                if (nextLabel == currentSpot.label) continue;
                                currentSpot = currentSpot.fusion(this.spots.get(nextLabel));
                                currentSpot.addVox(v);
                            }
                        }
                    }
                    if (currentSpot != null) continue;
                    this.spots.put(currentLabel, new Spot(currentLabel++, v));
                }
            }
        }
    }

    private void labelSpotsCheckSize(ImageHandler mask) {
        this.currentMask = mask;
        this.labels = new int[mask.sizeZ][mask.sizeXY];
        int sizeX = mask.sizeX;
        this.spots = new HashMap();
        int currentLabel = 1;
        if (this.debug) {
            System.out.println("Labelling...");
        }
        for (int z = 0; z < mask.sizeZ; ++z) {
            for (int y = 0; y < mask.sizeY; ++y) {
                for (int x = 0; x < sizeX; ++x) {
                    int nextLabel;
                    int xy = x + y * sizeX;
                    if (mask.getPixel(xy, z) == 0.0f) continue;
                    Spot currentSpot = null;
                    Vox3D v = new Vox3D(xy, z);
                    if (x > 0 && (nextLabel = this.labels[z][xy - 1]) != 0) {
                        if (currentSpot == null) {
                            currentSpot = this.spots.get(nextLabel);
                            if (!currentSpot.tooBig) {
                                currentSpot.addVox(v);
                                if (currentSpot.getSize() > this.maxsize) {
                                    currentSpot.tooBig = true;
                                }
                            }
                        } else if (nextLabel != currentSpot.label && !currentSpot.tooBig && !this.spots.get((Object)Integer.valueOf((int)nextLabel)).tooBig) {
                            currentSpot = currentSpot.fusion(this.spots.get(nextLabel));
                            currentSpot.addVox(v);
                            if (currentSpot.getSize() > this.maxsize) {
                                currentSpot.tooBig = true;
                            }
                        }
                    }
                    if (y > 0 && (nextLabel = this.labels[z][xy - sizeX]) != 0) {
                        if (currentSpot == null) {
                            currentSpot = this.spots.get(nextLabel);
                            if (!currentSpot.tooBig) {
                                currentSpot.addVox(v);
                                if (currentSpot.getSize() > this.maxsize) {
                                    currentSpot.tooBig = true;
                                }
                            }
                        } else if (nextLabel != currentSpot.label && !currentSpot.tooBig && !this.spots.get((Object)Integer.valueOf((int)nextLabel)).tooBig) {
                            currentSpot = currentSpot.fusion(this.spots.get(nextLabel));
                            currentSpot.addVox(v);
                            if (currentSpot.getSize() > this.maxsize) {
                                currentSpot.tooBig = true;
                            }
                        }
                    }
                    if (z > 0 && (nextLabel = this.labels[z - 1][xy]) != 0) {
                        if (currentSpot == null) {
                            currentSpot = this.spots.get(nextLabel);
                            if (!currentSpot.tooBig) {
                                currentSpot.addVox(v);
                                if (currentSpot.getSize() > this.maxsize) {
                                    currentSpot.tooBig = true;
                                }
                            }
                        } else if (nextLabel != currentSpot.label && !currentSpot.tooBig && !this.spots.get((Object)Integer.valueOf((int)nextLabel)).tooBig) {
                            currentSpot = currentSpot.fusion(this.spots.get(nextLabel));
                            currentSpot.addVox(v);
                            if (currentSpot.getSize() > this.maxsize) {
                                currentSpot.tooBig = true;
                            }
                        }
                    }
                    if (currentSpot != null) continue;
                    this.spots.put(currentLabel, new Spot(currentLabel++, v));
                }
            }
        }
    }

    private void labelIndividualVoxel(ImageHandler mask) {
        this.currentMask = mask;
        this.labels = new int[mask.sizeZ][mask.sizeXY];
        int sizeX = mask.sizeX;
        this.spots = new HashMap();
        int currentLabel = 1;
        if (this.debug) {
            System.out.println("Labelling...");
        }
        for (int z = 0; z < mask.sizeZ; ++z) {
            for (int y = 0; y < mask.sizeY; ++y) {
                for (int x = 0; x < sizeX; ++x) {
                    int xy = x + y * sizeX;
                    if (mask.getPixel(xy, z) == 0.0f) continue;
                    Vox3D v = new Vox3D(xy, z);
                    this.spots.put(currentLabel, new Spot(currentLabel++, v));
                }
            }
        }
    }

    public ImageInt getLabels(ImageHandler mask, boolean connex6) {
        if (this.spots == null || mask != this.currentMask) {
            if (connex6) {
                this.labelSpots6(mask);
            } else {
                this.labelSpots26(mask);
            }
        }
        ImageShort res = new ImageShort(mask.getTitle() + "::segmented", mask.sizeX, mask.sizeY, mask.sizeZ);
        int label = 1;
        for (Spot s : this.spots.values()) {
            ArrayList<Vox3D> a = s.voxels;
            if (a.size() < this.minSize || a.size() > this.maxsize) continue;
            for (Vox3D vox : a) {
                res.pixels[vox.z][vox.xy] = label;
            }
            label = (short)(label + 1);
        }
        return res;
    }

    public ImageFloat getLabelsFloat(ImageHandler mask) {
        return this.getLabelsFloat(mask, false);
    }

    public ImageFloat getLabelsFloat(ImageHandler mask, boolean connex6) {
        if (this.spots == null || mask != this.currentMask) {
            if (connex6) {
                this.labelSpots6(mask);
            } else {
                this.labelSpots26(mask);
            }
        }
        ImageFloat res = new ImageFloat(mask.getTitle() + "::segmented", mask.sizeX, mask.sizeY, mask.sizeZ);
        int label = 1;
        for (Spot s : this.spots.values()) {
            ArrayList<Vox3D> a = s.voxels;
            if (a.size() < this.minSize || a.size() > this.maxsize) continue;
            for (Vox3D vox : a) {
                res.pixels[vox.z][vox.xy] = label;
            }
            label = (short)(label + 1);
        }
        return res;
    }

    public ImageInt getLabels(ImageHandler mask) {
        return this.getLabels(mask, false);
    }

    public int getNbObjectsTotal(ImageHandler mask, boolean connex6) {
        if (this.spots == null || mask != this.currentMask) {
            if (connex6) {
                this.labelSpots6(mask);
            } else {
                this.labelSpots26(mask);
            }
        }
        return this.spots.size();
    }

    public ImageInt getLabelsIndividualVoxels(ImageHandler mask) {
        if (this.spots == null || mask != this.currentMask) {
            this.labelIndividualVoxel(mask);
        }
        ImageShort res = new ImageShort(mask.getTitle() + "::segmented", mask.sizeX, mask.sizeY, mask.sizeZ);
        short label = 1;
        for (Spot s : this.spots.values()) {
            Vox3D vox = s.voxels.get(0);
            res.pixels[vox.z][vox.xy] = label;
            label = (short)(label + 1);
        }
        return res;
    }

    public int getNbObjectsTotal(ImageHandler mask) {
        return this.getNbObjectsTotal(mask, false);
    }

    public int getNbObjectsinSizeRange(ImageHandler mask, boolean connex6) {
        return this.getObjects(mask, connex6).size();
    }

    public int getNbObjectsinSizeRange(ImageHandler mask) {
        return this.getNbObjectsinSizeRange(mask, false);
    }

    public ArrayList<Object3DVoxels> getObjects(ImageHandler mask, boolean connex6) {
        if (this.spots == null || mask != this.currentMask) {
            if (connex6) {
                this.labelSpots6(mask);
            } else {
                this.labelSpots26(mask);
            }
        }
        ArrayList<Object3DVoxels> objects = new ArrayList<Object3DVoxels>();
        int sizeX = mask.sizeX;
        int label = 1;
        for (Spot s : this.spots.values()) {
            ArrayList<Vox3D> a = s.voxels;
            if (a.size() < this.minSize || a.size() > this.maxsize) continue;
            ArrayList<Voxel3D> voxels3D = new ArrayList<Voxel3D>();
            for (Vox3D vox : a) {
                voxels3D.add(new Voxel3D(vox.xy % sizeX, vox.xy / sizeX, vox.z, label));
            }
            ArrayList<Voxel3D> noDuplicate = new ArrayList<Voxel3D>(new HashSet(voxels3D));
            Object3DVoxels object3DVoxels = new Object3DVoxels(noDuplicate);
            Object3D_IJUtils.setCalibration(object3DVoxels, mask.getCalibration());
            objects.add(object3DVoxels);
            label = (short)(label + 1);
        }
        return objects;
    }

    public ArrayList<Object3DVoxels> getObjects(ImageHandler mask) {
        return this.getObjects(mask, false);
    }

    protected class Vox3D {
        public int xy;
        public int z;

        public Vox3D(int xy, int z) {
            this.xy = xy;
            this.z = z;
        }

        public void setLabel(int label) {
            ImageLabeller.this.labels[this.z][this.xy] = label;
        }

        public boolean equals(Object o) {
            if (o instanceof Vox3D) {
                return this.xy == ((Vox3D)o).xy && this.z == ((Vox3D)o).z;
            }
            return false;
        }

        public int hashCode() {
            int hash = 3;
            hash = 47 * hash + this.xy;
            hash = 47 * hash + this.z;
            return hash;
        }
    }

    private class Spot {
        ArrayList<Vox3D> voxels;
        int label;
        boolean tooBig = false;

        public Spot(int label, Vox3D v) {
            this.label = label;
            this.voxels = new ArrayList();
            this.voxels.add(v);
            v.setLabel(label);
        }

        public void addVox(Vox3D vox) {
            this.voxels.add(vox);
            vox.setLabel(this.label);
        }

        public void setLabel(int label) {
            this.label = label;
            for (Vox3D v : this.voxels) {
                v.setLabel(label);
            }
        }

        public Spot fusion(Spot other) {
            if (other.label < this.label) {
                return other.fusion(this);
            }
            ImageLabeller.this.spots.remove(other.label);
            this.voxels.addAll(other.voxels);
            other.setLabel(this.label);
            return this;
        }

        public int getSize() {
            return this.voxels.size();
        }
    }
}

