/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.distanceMap3d;

import ij.IJ;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import mcib3d.image3d.ImageFloat;

public class EdtFloatInv {
    public ImageFloat run(ImageFloat imp, float thresh, float scaleXY, float scaleZ, int nbCPUs) throws Exception {
        int thread;
        int thread2;
        int thread3;
        int w = imp.sizeX;
        int h = imp.sizeY;
        int d = imp.sizeZ;
        float scale = scaleZ / scaleXY;
        float[][] data = imp.pixels;
        ImageStack sStack = new ImageStack(w, h);
        float[][] s = new float[d][];
        for (int k = 0; k < d; ++k) {
            FloatProcessor ipk = new FloatProcessor(w, h);
            sStack.addSlice(null, (ImageProcessor)ipk);
            s[k] = (float[])ipk.getPixels();
        }
        Step1Thread[] s1t = new Step1Thread[nbCPUs];
        for (thread3 = 0; thread3 < nbCPUs; ++thread3) {
            s1t[thread3] = new Step1Thread(thread3, nbCPUs, w, h, d, thresh, s, data);
            s1t[thread3].start();
        }
        try {
            for (thread3 = 0; thread3 < nbCPUs; ++thread3) {
                s1t[thread3].join();
            }
        }
        catch (InterruptedException ie) {
            IJ.error((String)"A thread was interrupted in step 1 .");
        }
        Step2Thread[] s2t = new Step2Thread[nbCPUs];
        for (thread2 = 0; thread2 < nbCPUs; ++thread2) {
            s2t[thread2] = new Step2Thread(thread2, nbCPUs, w, h, d, s);
            s2t[thread2].start();
        }
        try {
            for (thread2 = 0; thread2 < nbCPUs; ++thread2) {
                s2t[thread2].join();
            }
        }
        catch (InterruptedException ie) {
            IJ.error((String)"A thread was interrupted in step 2 .");
        }
        Step3Thread[] s3t = new Step3Thread[nbCPUs];
        for (thread = 0; thread < nbCPUs; ++thread) {
            s3t[thread] = new Step3Thread(thread, nbCPUs, w, h, d, s, data, thresh, scale);
            s3t[thread].start();
        }
        try {
            for (thread = 0; thread < nbCPUs; ++thread) {
                s3t[thread].join();
            }
        }
        catch (InterruptedException ie) {
            IJ.error((String)"A thread was interrupted in step 3 .");
        }
        float distMax = 0.0f;
        int wh = w * h;
        for (int k = 0; k < d; ++k) {
            float[] sk = s[k];
            for (int ind = 0; ind < wh; ++ind) {
                float dist;
                if (data[k][ind] > thresh) {
                    sk[ind] = 0.0f;
                    continue;
                }
                sk[ind] = dist = (float)Math.sqrt(sk[ind]) * scaleXY;
                distMax = dist > distMax ? dist : distMax;
            }
        }
        ImageFloat res = (ImageFloat)ImageFloat.wrap(sStack);
        res.setScale(imp);
        res.setOffset(imp);
        res.setMinAndMax(0.0f, distMax);
        return res;
    }

    String stripExtension(String name) {
        int dotIndex;
        if (name != null && (dotIndex = name.lastIndexOf(".")) >= 0) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }

    class Step3Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float thresh;
        float[][] s;
        float[][] data;
        float scaleZ;

        public Step3Thread(int thread, int nThreads, int w, int h, int d, float[][] s, float[][] data, float thresh, float scaleZ) {
            this.thresh = thresh;
            this.thread = thread;
            this.nThreads = nThreads;
            this.w = w;
            this.h = h;
            this.d = d;
            this.s = s;
            this.data = data;
            this.scaleZ = scaleZ * scaleZ;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int noResult = 3 * (n + 1) * (n + 1);
            float[] tempInt = new float[n];
            int[] tempS = new int[n];
            for (int j = this.thread; j < this.h; j += this.nThreads) {
                for (int i = 0; i < this.w; ++i) {
                    int zStop;
                    int zStart;
                    int k;
                    boolean nonempty = false;
                    for (k = 0; k < this.d; ++k) {
                        tempS[k] = (int)this.s[k][i + this.w * j];
                        if (tempS[k] <= 0) continue;
                        nonempty = true;
                    }
                    if (!nonempty) continue;
                    for (zStart = 0; zStart < this.d - 1 && tempS[zStart] == 0; ++zStart) {
                    }
                    if (zStart > 0) {
                        --zStart;
                    }
                    for (zStop = this.d - 1; zStop > 0 && tempS[zStop] == 0; --zStop) {
                    }
                    if (zStop < this.d - 1) {
                        ++zStop;
                    }
                    for (k = 0; k < this.d; ++k) {
                        if (!(this.data[k][i + this.w * j] <= this.thresh)) continue;
                        float min = noResult;
                        int zBegin = zStart;
                        int zEnd = zStop;
                        if (zBegin > k) {
                            zBegin = k;
                        }
                        if (zEnd < k) {
                            zEnd = k;
                        }
                        float delta = k - zBegin;
                        for (int z = zBegin; z <= zEnd; ++z) {
                            float f = delta;
                            float f2 = delta;
                            delta = f2 - 1.0f;
                            float test = (float)tempS[z] + f * f2 * this.scaleZ;
                            if (!(test < min)) continue;
                            min = test;
                        }
                        tempInt[k] = min;
                    }
                    for (k = 0; k < this.d; ++k) {
                        this.s[k][i + this.w * j] = tempInt[k];
                    }
                }
            }
        }
    }

    class Step2Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;

        public Step2Thread(int thread, int nThreads, int w, int h, int d, float[][] s) {
            this.thread = thread;
            this.nThreads = nThreads;
            this.w = w;
            this.h = h;
            this.d = d;
            this.s = s;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int noResult = 3 * (n + 1) * (n + 1);
            int[] tempInt = new int[n];
            int[] tempS = new int[n];
            for (int k = this.thread; k < this.d; k += this.nThreads) {
                float[] sk = this.s[k];
                for (int i = 0; i < this.w; ++i) {
                    int j;
                    boolean nonempty = false;
                    for (j = 0; j < this.h; ++j) {
                        tempS[j] = (int)sk[i + this.w * j];
                        if (tempS[j] <= 0) continue;
                        nonempty = true;
                    }
                    if (!nonempty) continue;
                    for (j = 0; j < this.h; ++j) {
                        int min = noResult;
                        int delta = j;
                        for (int y = 0; y < this.h; ++y) {
                            int test;
                            if ((test = tempS[y] + delta * delta--) >= min) continue;
                            min = test;
                        }
                        tempInt[j] = min;
                    }
                    for (j = 0; j < this.h; ++j) {
                        sk[i + this.w * j] = tempInt[j];
                    }
                }
            }
        }
    }

    class Step1Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float thresh;
        float[][] s;
        float[][] data;

        public Step1Thread(int thread, int nThreads, int w, int h, int d, float thresh, float[][] s, float[][] data) {
            this.thread = thread;
            this.nThreads = nThreads;
            this.w = w;
            this.h = h;
            this.d = d;
            this.thresh = thresh;
            this.data = data;
            this.s = s;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int noResult = 3 * (n + 1) * (n + 1);
            boolean[] background = new boolean[n];
            for (int k = this.thread; k < this.d; k += this.nThreads) {
                float[] sk = this.s[k];
                float[] dk = this.data[k];
                for (int j = 0; j < this.h; ++j) {
                    int i;
                    for (i = 0; i < this.w; ++i) {
                        background[i] = dk[i + this.w * j] > this.thresh;
                    }
                    for (i = 0; i < this.w; ++i) {
                        int test;
                        int x;
                        int min = noResult;
                        for (x = i; x < this.w; ++x) {
                            if (!background[x]) continue;
                            test = i - x;
                            test *= test;
                            min = test;
                            break;
                        }
                        for (x = i - 1; x >= 0; --x) {
                            if (!background[x]) continue;
                            test = i - x;
                            if ((test *= test) >= min) break;
                            min = test;
                            break;
                        }
                        sk[i + this.w * j] = min;
                    }
                }
            }
        }
    }
}

