/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

public class CannyDeriche1D {
    private double[] line;
    private double alpha;

    public CannyDeriche1D(double[] li, double a) {
        this.line = li;
        this.alpha = a;
    }

    private double[] computeCannyderiche() {
        int n = this.line.length;
        double[] der = new double[n];
        double[] der1 = new double[n];
        double[] der2 = new double[n];
        if (n > 2) {
            int i;
            double e = Math.exp(-this.alpha);
            double e2 = Math.exp(-2.0 * this.alpha);
            double a0 = 0.0;
            double a1 = 1.0;
            double a2 = -1.0;
            double a3 = 0.0;
            double b1 = 2.0 * e;
            double b2 = -e2;
            der1[0] = this.line[0] * (a0 + a1) / (1.0 - b1 - b2);
            der1[1] = this.line[1] * a0 + a1 * this.line[0] + der1[0] * (b1 + b2);
            der2[n - 1] = this.line[n - 1] * (a2 + a3) / (1.0 - b1 - b2);
            der2[n - 2] = this.line[n - 1] * a2 + a3 * this.line[n - 1] + der2[n - 1] * (b1 + b2);
            for (i = 2; i < n; ++i) {
                der1[i] = a0 * this.line[i] + a1 * this.line[i - 1] + b1 * der1[i - 1] + b2 * der1[i - 2];
            }
            for (i = n - 3; i >= 0; --i) {
                der2[i] = a2 * this.line[i + 1] + a3 * this.line[i + 2] + b1 * der2[i + 1] + b2 * der2[i + 2];
            }
            for (i = 0; i < n; ++i) {
                der[i] = b2 * (der1[i] + der2[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                der[i] = 0.0;
            }
        }
        return der;
    }

    public double[] getCannyDeriche() {
        return this.computeCannyderiche();
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public double[] getLine() {
        return this.line;
    }

    public void setLine(double[] line) {
        this.line = line;
    }
}

