/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import vtk.vtkJavaGarbageCollector;
import vtk.vtkJavaMemoryManager;
import vtk.vtkObjectBase;
import vtk.vtkReferenceInformation;

public class vtkJavaMemoryManagerImpl
implements vtkJavaMemoryManager {
    private vtkJavaGarbageCollector garbageCollector;
    private ReentrantLock lock = new ReentrantLock();
    private vtkReferenceInformation lastGcResult;
    private HashMap<Long, WeakReference<vtkObjectBase>> objectMap = new HashMap();
    private HashMap<Long, String> objectMapClassName = new HashMap();

    public vtkJavaMemoryManagerImpl() {
        this.garbageCollector = new vtkJavaGarbageCollector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public vtkObjectBase getJavaObject(Long vtkId) {
        vtkObjectBase resultObject;
        if (vtkId == null || vtkId == 0L) {
            throw new RuntimeException("Invalid ID, can not be null or equal to 0.");
        }
        WeakReference<vtkObjectBase> value = this.objectMap.get(vtkId);
        vtkObjectBase vtkObjectBase2 = resultObject = value == null ? null : (vtkObjectBase)value.get();
        if (value == null || resultObject == null) {
            try {
                this.lock.lock();
                value = this.objectMap.get(vtkId);
                vtkObjectBase vtkObjectBase3 = resultObject = value == null ? null : (vtkObjectBase)value.get();
                if (resultObject != null) {
                    vtkObjectBase vtkObjectBase4 = resultObject;
                    return vtkObjectBase4;
                }
                if (value != null && resultObject == null) {
                    this.unRegisterJavaObject(vtkId);
                }
                if (resultObject == null) {
                    try {
                        String className = vtkObjectBase.VTKGetClassNameFromReference(vtkId);
                        Class<?> c = Class.forName("vtk." + className);
                        Constructor<?> cons = c.getConstructor(Long.TYPE);
                        resultObject = (vtkObjectBase)cons.newInstance(vtkId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return resultObject;
    }

    @Override
    public void registerJavaObject(Long id, vtkObjectBase obj) {
        try {
            this.lock.lock();
            this.objectMap.put(id, new WeakReference<vtkObjectBase>(obj));
            this.objectMapClassName.put(id, obj.GetClassName());
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void unRegisterJavaObject(Long id) {
        block4: {
            try {
                this.lock.lock();
                this.objectMapClassName.remove(id);
                WeakReference<vtkObjectBase> value = this.objectMap.remove(id);
                if (value != null) {
                    vtkObjectBase.VTKDeleteReference(id);
                    break block4;
                }
                throw new RuntimeException("You try to delete a vtkObject that is not referenced in the Java object Map. You may have call Delete() twice.");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public vtkReferenceInformation gc(boolean debug) {
        System.gc();
        try {
            this.lock.lock();
            vtkReferenceInformation infos = new vtkReferenceInformation(debug);
            for (Long id : new TreeSet<Long>(this.objectMap.keySet())) {
                vtkObjectBase obj = (vtkObjectBase)this.objectMap.get(id).get();
                if (obj == null) {
                    infos.addFreeObject(this.objectMapClassName.get(id));
                    this.unRegisterJavaObject(id);
                    continue;
                }
                infos.addKeptObject(this.objectMapClassName.get(id));
            }
            this.lastGcResult = infos;
            vtkReferenceInformation vtkReferenceInformation2 = infos;
            return vtkReferenceInformation2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public vtkJavaGarbageCollector getAutoGarbageCollector() {
        return this.garbageCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAll() {
        int size = this.objectMap.size();
        try {
            this.lock.lock();
            for (Long id : new TreeSet<Long>(this.objectMap.keySet())) {
                this.unRegisterJavaObject(id);
            }
        }
        finally {
            this.lock.unlock();
        }
        return size;
    }

    @Override
    public int getSize() {
        return this.objectMap.size();
    }

    @Override
    public vtkReferenceInformation getLastReferenceInformation() {
        return this.lastGcResult;
    }
}

