/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.roiintensityevolution;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.sequence.Sequence;
import icy.type.collection.array.ArrayUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.locks.ReentrantLock;
import org.jfree.data.xy.XYSeries;

public class ROIAnalysis {
    private ROI roi;
    private Sequence sequence;
    private String description;
    private final XYSeries[] meanIntensity;
    private final XYSeries[] minIntensity;
    private final XYSeries[] maxIntensity;
    private final XYSeries[] medianIntensity;
    private final XYSeries[] sumIntensity;
    private final XYSeries[] varIntensity;
    private final XYSeries[] roiSize;
    ReentrantLock initLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROIAnalysis(ROI roi, Sequence sequence, String description, double threshold, boolean overthreshold, double scaling) {
        try {
            int c;
            this.initLock.lock();
            if (roi == null) {
                throw new IllegalArgumentException("NULL roi object is not allowed for creating a TrackAnalysis instance");
            }
            if (sequence == null) {
                throw new IllegalArgumentException("NULL Sequence object is not allowed for creating a TrackAnalysis instance");
            }
            if (description == null) {
                throw new IllegalArgumentException("NULL description object is not allowed for creating a TrackAnalysis instance");
            }
            this.roi = roi;
            this.sequence = sequence;
            this.description = description;
            this.meanIntensity = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.meanIntensity[c] = new XYSeries((Comparable)((Object)description));
            }
            this.minIntensity = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.minIntensity[c] = new XYSeries((Comparable)((Object)description));
            }
            this.maxIntensity = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.maxIntensity[c] = new XYSeries((Comparable)((Object)description));
            }
            this.medianIntensity = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.medianIntensity[c] = new XYSeries((Comparable)((Object)description));
            }
            this.sumIntensity = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.sumIntensity[c] = new XYSeries((Comparable)((Object)description));
            }
            this.varIntensity = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.varIntensity[c] = new XYSeries((Comparable)((Object)description));
            }
            this.roiSize = new XYSeries[sequence.getSizeC()];
            for (c = 0; c < sequence.getSizeC(); ++c) {
                this.roiSize[c] = new XYSeries((Comparable)((Object)description));
            }
            this.fillSeriesNoLock(threshold, overthreshold, scaling);
        }
        finally {
            this.initLock.unlock();
        }
    }

    private void fillSeriesNoLock(double threshold, boolean overthreshold, double areaScale) {
        for (int c = 0; c < this.sequence.getSizeC(); ++c) {
            this.meanIntensity[c].clear();
            this.maxIntensity[c].clear();
            this.minIntensity[c].clear();
            this.varIntensity[c].clear();
            this.sumIntensity[c].clear();
            this.medianIntensity[c].clear();
        }
        BooleanMask2D[] masks = new BooleanMask2D[this.sequence.getSizeZ()];
        if (this.roi instanceof ROI2D) {
            ROI2D roi2d = (ROI2D)this.roi;
            BooleanMask2D mask = roi2d.getBooleanMask(true);
            for (int z = 0; z < masks.length; ++z) {
                if (!roi2d.isActiveFor(z, -1, -1)) continue;
                masks[z] = mask;
            }
        } else if (this.roi instanceof ROI3D) {
            for (int z = 0; z < this.sequence.getSizeZ(); ++z) {
                masks[z] = ((ROI3D)this.roi).getBooleanMask2D(z, true);
            }
        } else {
            for (int t = 0; t < this.sequence.getSizeT(); ++t) {
                for (int c = 0; c < this.sequence.getSizeC(); ++c) {
                    this.meanIntensity[c].add((double)t, 0.0);
                    this.maxIntensity[c].add((double)t, 0.0);
                    this.minIntensity[c].add((double)t, 0.0);
                    this.varIntensity[c].add((double)t, 0.0);
                    this.sumIntensity[c].add((double)t, 0.0);
                    this.medianIntensity[c].add((double)t, 0.0);
                    this.roiSize[c].add((double)t, 0.0);
                }
            }
            return;
        }
        for (int t = 0; t < this.sequence.getSizeT(); ++t) {
            for (int c = 0; c < this.sequence.getSizeC(); ++c) {
                ArrayList<Double> valueList = new ArrayList<Double>();
                double sum = 0.0;
                double min = 0.0;
                double max = 0.0;
                double sumSq = 0.0;
                int cntPix = 0;
                for (int z = 0; z < this.sequence.getSizeZ(); ++z) {
                    BooleanMask2D mask2d = masks[z];
                    if (mask2d == null || mask2d.isEmpty()) continue;
                    IcyBufferedImage image = this.sequence.getImage(t, z);
                    IcyBufferedImage subImage = IcyBufferedImageUtil.getSubImage((IcyBufferedImage)image, (Rectangle)mask2d.bounds);
                    boolean[] mask = mask2d.mask;
                    double[] data = (double[])ArrayUtil.arrayToDoubleArray((Object)subImage.getDataXY(c), (boolean)image.isSignedDataType());
                    for (int off = 0; off < data.length; ++off) {
                        if (!mask[off]) continue;
                        double value = data[off];
                        sum += value;
                        sumSq += value * value;
                        valueList.add(new Double(value));
                        if (value < min) {
                            min = value;
                        }
                        if (value > max) {
                            max = value;
                        }
                        if (overthreshold) {
                            if (!(value > threshold)) continue;
                            ++cntPix;
                            continue;
                        }
                        if (!(value < threshold)) continue;
                        ++cntPix;
                    }
                }
                int cntValues = valueList.size();
                double mean = 0.0;
                double var = 0.0;
                if (cntValues > 0) {
                    mean = sum / (double)cntValues;
                    var = sumSq / (double)cntValues - mean * mean;
                }
                this.meanIntensity[c].add((double)t, mean);
                this.maxIntensity[c].add((double)t, max);
                this.minIntensity[c].add((double)t, min);
                this.varIntensity[c].add((double)t, var);
                this.sumIntensity[c].add((double)t, sum);
                if (cntValues > 0) {
                    Collections.sort(valueList);
                    if (cntValues == 1) {
                        this.medianIntensity[c].add((double)t, (Number)valueList.get(0));
                    } else if (cntValues % 2 == 0) {
                        this.medianIntensity[c].add((double)t, (Double)valueList.get(cntValues / 2) + ((Double)valueList.get(cntValues / 2) - 1.0) / 2.0);
                    } else {
                        this.medianIntensity[c].add((double)t, (Number)valueList.get(cntValues / 2));
                    }
                }
                this.roiSize[c].add((double)t, (double)cntPix * areaScale);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillSeries(double threshold, boolean overthreshold, double scale) {
        try {
            this.initLock.lock();
            this.fillSeriesNoLock(threshold, overthreshold, scale);
        }
        finally {
            this.initLock.unlock();
        }
    }

    public int getNumChannels() {
        try {
            this.initLock.lock();
            int n = this.sequence.getSizeC();
            return n;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public ROI getROI() {
        try {
            this.initLock.lock();
            ROI rOI = this.roi;
            return rOI;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getMeanIntensity() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.meanIntensity;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getMedianIntensity() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.medianIntensity;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getSumIntensity() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.sumIntensity;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getVarIntensity() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.varIntensity;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getMinIntensity() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.minIntensity;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getMaxIntensity() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.maxIntensity;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public XYSeries[] getROISize() {
        try {
            this.initLock.lock();
            XYSeries[] xYSeriesArray = this.roiSize;
            return xYSeriesArray;
        }
        finally {
            this.initLock.unlock();
        }
    }

    public String getDescription() {
        try {
            this.initLock.lock();
            String string = this.description;
            return string;
        }
        finally {
            this.initLock.unlock();
        }
    }
}

