/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import plugins.adufour.blocks.util.NoSuchVariableException;
import plugins.adufour.blocks.util.VarListListener;
import plugins.adufour.blocks.util.VarVisibilityListener;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;

public class VarList
implements Iterable<Var<?>> {
    private final LinkedHashMap<String, Var<?>> varMap = new LinkedHashMap();
    private final HashMap<Var<?>, Boolean> visibilityMap = new HashMap();
    private final HashMap<Var<?>, Boolean> runtimeVariableMap = new HashMap();
    private final ArrayList<VarVisibilityListener> visibilityListeners = new ArrayList();
    private final ArrayList<VarListListener> varListListeners = new ArrayList();

    @Deprecated
    public void add(Var<?> variable) {
        this.add(variable.getName(), variable);
    }

    public void add(String uid, Var<?> variable) {
        this.add(uid, variable, false);
    }

    public void addRuntimeVariable(String uid, VarMutable variable) {
        this.add(uid, (Var<?>)variable, true);
    }

    private void add(String uid, Var<?> variable, boolean isRuntimeVariable) {
        if (this.varMap.containsKey(uid)) {
            throw new IllegalArgumentException("A variable with same unique ID (" + uid + ") exists in the map");
        }
        this.varMap.put(uid, variable);
        this.visibilityMap.put(variable, !uid.contains(":"));
        this.runtimeVariableMap.put(variable, isRuntimeVariable);
        for (VarListListener l : this.varListListeners) {
            l.variableAdded(this, variable);
        }
    }

    public void addVarListListener(VarListListener listener) {
        this.varListListeners.add(listener);
    }

    public void addVisibilityListener(VarVisibilityListener listener) {
        this.visibilityListeners.add(listener);
    }

    public void clear() {
        ArrayList vars = new ArrayList(this.varMap.values());
        for (Var<?> var : vars) {
            this.remove(var);
        }
    }

    public boolean contains(Var<?> variable) {
        return this.varMap.containsValue(variable);
    }

    public Var<?> first() {
        Iterator<Var<?>> iterator = this.varMap.values().iterator();
        if (iterator.hasNext()) {
            Var<?> v = iterator.next();
            return v;
        }
        return null;
    }

    @Deprecated
    public <T> Var<T> get(int varID) throws NoSuchVariableException {
        int id = 0;
        for (Var<?> var : this) {
            if (id == varID) {
                return var;
            }
            ++id;
        }
        throw new NoSuchVariableException("No variable with ID " + varID);
    }

    public <T> Var<T> get(String uid) {
        Var<?> var = this.varMap.get(uid);
        return var == null ? null : var;
    }

    public String getID(Var<?> var) throws NoSuchVariableException {
        for (String uid : this.varMap.keySet()) {
            if (this.varMap.get(uid) != var) continue;
            return uid;
        }
        throw new NoSuchVariableException("Variable " + var.getName() + " does not exist in this list");
    }

    @Deprecated
    public int indexOf(Var<?> variable) throws NoSuchVariableException {
        int index = 0;
        for (Var<?> var : this) {
            if (variable == var) {
                return index;
            }
            ++index;
        }
        throw new NoSuchVariableException(variable.getName());
    }

    public boolean isRuntimeVariable(Var<?> var) {
        return this.runtimeVariableMap.get(var);
    }

    public boolean isVisible(Var<?> var) {
        return this.visibilityMap.get(var);
    }

    @Override
    public Iterator<Var<?>> iterator() {
        return this.varMap.values().iterator();
    }

    public void remove(Var<?> var) {
        if (var.getReference() != null) {
            var.setReference(null);
            return;
        }
        this.varMap.remove(this.getID(var));
        this.visibilityMap.remove(var);
        this.runtimeVariableMap.remove(var);
        for (VarListListener l : this.varListListeners) {
            l.variableRemoved(this, var);
        }
    }

    public void removeVarListListener(VarListListener listener) {
        this.varListListeners.remove(listener);
    }

    public void removeVisibilityListener(VarVisibilityListener listener) {
        this.visibilityListeners.remove(listener);
    }

    public void setVisible(Var<?> var, boolean visible) {
        if (!this.visibilityMap.containsKey(var)) {
            return;
        }
        if (this.visibilityMap.get(var) != visible) {
            this.visibilityMap.put(var, visible);
            for (VarVisibilityListener l : this.visibilityListeners) {
                l.visibilityChanged(var, visible);
            }
        }
    }

    public int size() {
        return this.varMap.size();
    }
}

