/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptingconsole;

import icy.gui.frame.IcyFrame;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngine;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngineHandler;

public class BindingsScriptFrame
extends IcyFrame {
    private ScriptEngine engine;
    private JButton btnFreeVar;
    private JTable listVariables;
    private BindingsTableModel model;
    private static BindingsScriptFrame singleton = new BindingsScriptFrame();

    protected BindingsScriptFrame() {
        super("Engine Bindings", true, true, true);
        JPanel mainPanel = new JPanel();
        this.btnFreeVar = new JButton("Free Var");
        this.btnFreeVar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int selectedRow = BindingsScriptFrame.this.listVariables.getSelectedRow();
                Object o = BindingsScriptFrame.this.listVariables.getValueAt(selectedRow, 0);
                Object val = BindingsScriptFrame.this.listVariables.getValueAt(selectedRow, 1);
                if (val instanceof NativeArray) {
                    int i = 0;
                    while ((long)i < ((NativeArray)val).getLength()) {
                        ((NativeArray)val).delete(i);
                        ++i;
                    }
                } else if (val instanceof IdScriptableObject || val instanceof NativeJavaObject) {
                    Scriptable scope = ((NativeJavaObject)val).getParentScope();
                    scope.put((String)o, scope, null);
                }
                BindingsScriptFrame.this.engine.deleteBinding((String)o);
                BindingsScriptFrame.this.update();
            }
        });
        JButton btnRefresh = new JButton("Refresh");
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BindingsScriptFrame.this.update();
            }
        });
        this.model = new BindingsTableModel();
        this.listVariables = new JTable(this.model);
        mainPanel.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.listVariables);
        scroll.setHorizontalScrollBarPolicy(32);
        scroll.setVerticalScrollBarPolicy(22);
        mainPanel.add((Component)scroll, "Center");
        JPanel panelSouth = new JPanel();
        panelSouth.setLayout(new BoxLayout(panelSouth, 0));
        panelSouth.add(Box.createHorizontalGlue());
        panelSouth.add(this.btnFreeVar);
        panelSouth.add(Box.createHorizontalGlue());
        panelSouth.add(btnRefresh);
        panelSouth.add(Box.createHorizontalGlue());
        mainPanel.add((Component)panelSouth, "South");
        this.setDefaultCloseOperation(1);
        this.setContentPane(mainPanel);
        this.addToDesktopPane();
        this.setSize(200, 700);
    }

    public void setEngine(ScriptEngine engine) {
        this.engine = engine;
    }

    public void update() {
        if (this.engine != null) {
            String languageName = this.engine.getName();
            ScriptEngine engine = ScriptEngineHandler.getEngine(languageName);
            if (engine != this.engine) {
                this.engine = engine;
            }
            ThreadUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    BindingsScriptFrame.this.model.fireTableDataChanged();
                    BindingsScriptFrame.this.listVariables.repaint();
                }
            });
        }
    }

    public static BindingsScriptFrame getInstance() {
        return singleton;
    }

    private class BindingsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private BindingsTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Binding";
            }
            if (column == 1) {
                return "Value";
            }
            return "";
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (BindingsScriptFrame.this.engine != null) {
                return BindingsScriptFrame.this.engine.getBindings().values().size();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Set<String> keyset = BindingsScriptFrame.this.engine.getBindings().keySet();
            if (rowIndex >= 0 && rowIndex < keyset.size()) {
                if (BindingsScriptFrame.this.engine == null) {
                    return null;
                }
                if (columnIndex == 0) {
                    return keyset.toArray()[rowIndex];
                }
                Object o = BindingsScriptFrame.this.engine.getBindings().values().toArray()[rowIndex];
                return o;
            }
            return null;
        }
    }
}

