/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.MHTracker;

import java.util.concurrent.locks.ReentrantLock;

public class FixedThreadPool {
    Task[] threadPool;
    boolean[] finishedTasks;
    int nextThread = 0;
    ReentrantLock poolLock = new ReentrantLock();
    ReentrantLock poolStopped = new ReentrantLock();
    int numStoppedThreads = 0;
    RunningThread[] runningThreads;
    int numThreads;

    public FixedThreadPool(Task[] threadPool) {
        this.threadPool = threadPool;
        this.finishedTasks = new boolean[threadPool.length];
    }

    public void runThreads(int numThreads) {
        this.numThreads = numThreads;
        this.nextThread = 0;
        this.runningThreads = new RunningThread[numThreads];
        this.numStoppedThreads = 0;
        for (int i = 0; i < numThreads; ++i) {
            RunningThread thr;
            this.runningThreads[i] = thr = new RunningThread();
        }
        for (RunningThread thr : this.runningThreads) {
            thr.start();
        }
        this.waitForTermination();
        try {
            if (this.numStoppedThreads < numThreads) {
                throw new Exception("ERRR " + this.numStoppedThreads + " " + numThreads);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForTermination() {
        FixedThreadPool fixedThreadPool = this;
        synchronized (fixedThreadPool) {
            while (this.numStoppedThreads < this.numThreads) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface Task {
        public void run();
    }

    class RunningThread
    extends Thread {
        boolean stop = false;

        RunningThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Task task = null;
            FixedThreadPool fixedThreadPool = FixedThreadPool.this;
            synchronized (fixedThreadPool) {
                if (FixedThreadPool.this.nextThread < FixedThreadPool.this.threadPool.length) {
                    task = FixedThreadPool.this.threadPool[FixedThreadPool.this.nextThread];
                    ++FixedThreadPool.this.nextThread;
                }
            }
            while (task != null) {
                task.run();
                task = null;
                fixedThreadPool = FixedThreadPool.this;
                synchronized (fixedThreadPool) {
                    if (FixedThreadPool.this.nextThread < FixedThreadPool.this.threadPool.length) {
                        task = FixedThreadPool.this.threadPool[FixedThreadPool.this.nextThread];
                        ++FixedThreadPool.this.nextThread;
                    }
                }
            }
            fixedThreadPool = FixedThreadPool.this;
            synchronized (fixedThreadPool) {
                ++FixedThreadPool.this.numStoppedThreads;
                FixedThreadPool.this.notify();
            }
        }
    }
}

