/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.preferences.PluginListPreferencePanel;
import icy.gui.preferences.PreferenceFrame;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.preferences.PluginPreferences;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PluginStartupPreferencePanel
extends PluginListPreferencePanel
implements PluginLoader.PluginLoaderListener {
    private static final long serialVersionUID = -3485972129754541852L;
    public static final String NODE_NAME = "Startup Plugin";
    final HashSet<String> inactives = new HashSet();

    public PluginStartupPreferencePanel(PreferenceFrame parent) {
        super(parent, NODE_NAME, "Plugin");
        PluginLoader.addListener(this);
        this.table.removeColumn(this.table.getColumn(columnIds[3]));
        this.action1Button.setVisible(false);
        this.action2Button.setVisible(false);
        this.refreshButton.setVisible(false);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 3));
        topPanel.add(Box.createVerticalStrut(4));
        topPanel.add(new JLabel("Setup plugin which should be loaded at startup (daemon plugin only)."));
        topPanel.add(Box.createVerticalStrut(4));
        this.mainPanel.add((Component)topPanel, "North");
        this.load();
        this.pluginsChanged();
    }

    @Override
    protected void closed() {
        super.closed();
        PluginLoader.removeListener(this);
    }

    @Override
    protected boolean isActive(PluginDescriptor plugin) {
        return !this.inactives.contains(plugin.getClassName());
    }

    @Override
    protected void setActive(PluginDescriptor plugin, boolean value) {
        String className = plugin.getClassName();
        if (value) {
            this.inactives.remove(className);
        } else if (!this.inactives.contains(className)) {
            this.inactives.add(className);
        }
    }

    @Override
    protected void load() {
        this.inactives.clear();
        this.inactives.addAll(PluginPreferences.getInactiveDaemons());
    }

    @Override
    protected void save() {
        PluginPreferences.setInactiveDaemons(new ArrayList<String>(this.inactives));
        PluginLoader.resetDaemons();
    }

    @Override
    protected void doAction1() {
    }

    @Override
    protected void doAction2() {
    }

    @Override
    protected void repositoryChanged() {
    }

    @Override
    protected void reloadPlugins() {
    }

    @Override
    protected String getStateValue(PluginDescriptor plugin) {
        return "";
    }

    protected ArrayList<PluginDescriptor> getPlugins() {
        return PluginLoader.getDaemonPlugins();
    }

    @Override
    protected void updateButtonsStateInternal() {
        super.updateButtonsStateInternal();
        if (PluginLoader.isLoading()) {
            this.refreshButton.setText("Reloading...");
            this.refreshButton.setEnabled(false);
        } else {
            this.refreshButton.setText("Reload list");
            this.refreshButton.setEnabled(true);
        }
        this.action1Button.setEnabled(false);
        this.action2Button.setEnabled(false);
    }

    @Override
    public void pluginLoaderChanged(PluginLoader.PluginLoaderEvent e) {
        this.pluginsChanged();
    }
}

