/*
 * Decompiled with CFR 0.152.
 */
package icy.image.colormodel;

import icy.common.CollapsibleEvent;
import icy.image.colormodel.IcyColorModel;

public class IcyColorModelEvent
implements CollapsibleEvent {
    private final IcyColorModel colorModel;
    private final IcyColorModelEventType type;
    private int component;

    public IcyColorModelEvent(IcyColorModel colorModel, IcyColorModelEventType type, int component) {
        this.colorModel = colorModel;
        this.type = type;
        this.component = component;
    }

    public IcyColorModel getColorModel() {
        return this.colorModel;
    }

    public IcyColorModelEventType getType() {
        return this.type;
    }

    public int getComponent() {
        return this.component;
    }

    @Override
    public boolean collapse(CollapsibleEvent event) {
        if (this.equals(event)) {
            IcyColorModelEvent e = (IcyColorModelEvent)event;
            if (e.getComponent() != this.component) {
                this.component = -1;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.colorModel.hashCode() ^ this.type.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IcyColorModelEvent) {
            IcyColorModelEvent e = (IcyColorModelEvent)obj;
            return this.colorModel == e.getColorModel() && this.type == e.getType();
        }
        return super.equals(obj);
    }

    public static enum IcyColorModelEventType {
        SCALER_CHANGED,
        COLORMAP_CHANGED;

    }
}

