/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.AreaXBody;
import icy.type.geom.areax.ChainEndX;
import icy.type.geom.areax.CurveLinkX;
import icy.type.geom.areax.CurveX;
import icy.type.geom.areax.EdgeX;
import icy.type.geom.areax.RawChainArrayList;
import icy.type.geom.areax.RawEdgeArrayList;
import icy.type.geom.areax.RawLinkArrayList;
import icy.type.geom.areax.RawSortedEdgeArrayList;
import java.util.Comparator;

public abstract class AreaOpX {
    public static final int CTAG_LEFT = 0;
    public static final int CTAG_RIGHT = 1;
    public static final int ETAG_IGNORE = 0;
    public static final int ETAG_ENTER = 1;
    public static final int ETAG_EXIT = -1;
    public static final int RSTAG_INSIDE = 1;
    public static final int RSTAG_OUTSIDE = -1;
    private static Comparator<EdgeX> YXTopComparator = new Comparator<EdgeX>(){

        @Override
        public int compare(EdgeX o1, EdgeX o2) {
            double v2;
            CurveX c1 = o1.getCurve();
            CurveX c2 = o2.getCurve();
            double v1 = c1.getYTop();
            if (v1 == (v2 = c2.getYTop()) && (v1 = c1.getXTop()) == (v2 = c2.getXTop())) {
                return 0;
            }
            if (v1 < v2) {
                return -1;
            }
            return 1;
        }
    };

    private AreaOpX() {
    }

    public abstract void newRow();

    public abstract int classify(EdgeX var1);

    public abstract int getState();

    public AreaXBody calculate(AreaXBody left, AreaXBody right) {
        if (!(this instanceof EOWindOp) && !(this instanceof NZWindOp)) {
            left = left.validate();
            right = right.validate();
        }
        RawSortedEdgeArrayList edges = new RawSortedEdgeArrayList(left.size() + right.size(), YXTopComparator);
        AreaOpX.addEdges(edges, left, 0);
        AreaOpX.addEdges(edges, right, 1);
        AreaXBody newCurves = this.pruneEdges(edges);
        return newCurves;
    }

    private static void addEdges(RawEdgeArrayList edges, AreaXBody curves, int curvetag) {
        for (int a = 0; a < curves.size(); ++a) {
            CurveX curve = curves.get(a);
            if (curve.getOrder() <= 0) continue;
            edges.add(new EdgeX(curve, curvetag));
        }
    }

    private AreaXBody pruneEdges(RawEdgeArrayList edges) {
        int numedges = edges.size();
        if (numedges < 2) {
            return new AreaXBody(null, 0);
        }
        EdgeX[] edgelist = edges.getArray();
        int left = 0;
        int right = 0;
        int cur = 0;
        int next = 0;
        double[] yrange = new double[2];
        RawLinkArrayList subcurves = new RawLinkArrayList(0);
        RawChainArrayList chains = new RawChainArrayList(0);
        RawLinkArrayList links = new RawLinkArrayList(0);
        while (left < numedges) {
            EdgeX e;
            double y = yrange[0];
            for (cur = next = right - 1; cur >= left; --cur) {
                e = edgelist[cur];
                if (!(e.getCurve().getYBot() > y)) continue;
                if (next > cur) {
                    edgelist[next] = e;
                }
                --next;
            }
            left = next + 1;
            if (left >= right) {
                if (right >= numedges) break;
                y = edgelist[right].getCurve().getYTop();
                if (y > yrange[0]) {
                    AreaOpX.finalizeSubCurves(subcurves, chains);
                }
                yrange[0] = y;
            }
            while (right < numedges && !((e = edgelist[right]).getCurve().getYTop() > y)) {
                ++right;
            }
            yrange[1] = edgelist[left].getCurve().getYBot();
            if (right < numedges && yrange[1] > (y = edgelist[right].getCurve().getYTop())) {
                yrange[1] = y;
            }
            int nexteq = 1;
            for (cur = left; cur < right; ++cur) {
                e = edgelist[cur];
                e.setEquivalence(0);
                for (next = cur; next > left; --next) {
                    EdgeX prevedge = edgelist[next - 1];
                    int ordering = e.compareTo(prevedge, yrange);
                    if (yrange[1] <= yrange[0]) {
                        throw new InternalError("backstepping to " + yrange[1] + " from " + yrange[0]);
                    }
                    if (ordering >= 0) {
                        if (ordering != 0) break;
                        int eq = prevedge.getEquivalence();
                        if (eq == 0) {
                            eq = nexteq++;
                            prevedge.setEquivalence(eq);
                        }
                        e.setEquivalence(eq);
                        break;
                    }
                    edgelist[next] = prevedge;
                }
                edgelist[next] = e;
            }
            this.newRow();
            double ystart = yrange[0];
            double yend = yrange[1];
            for (cur = left; cur < right; ++cur) {
                int etag;
                e = edgelist[cur];
                int eq = e.getEquivalence();
                if (eq != 0) {
                    int origstate = this.getState();
                    etag = origstate == 1 ? -1 : 1;
                    EdgeX activematch = null;
                    EdgeX longestmatch = e;
                    double furthesty = yend;
                    do {
                        this.classify(e);
                        if (activematch == null && e.isActiveFor(ystart, etag)) {
                            activematch = e;
                        }
                        if (!((y = e.getCurve().getYBot()) > furthesty)) continue;
                        longestmatch = e;
                        furthesty = y;
                    } while (++cur < right && (e = edgelist[cur]).getEquivalence() == eq);
                    --cur;
                    if (this.getState() == origstate) {
                        etag = 0;
                    } else {
                        e = activematch != null ? activematch : longestmatch;
                    }
                } else {
                    etag = this.classify(e);
                }
                if (etag == 0) continue;
                e.record(yend, etag);
                links.add(new CurveLinkX(e.getCurve(), ystart, yend, etag));
            }
            if (this.getState() != -1) {
                System.out.println("Still inside at end of active edge list!");
                System.out.println("num curves = " + (right - left));
                System.out.println("num links = " + links.size());
                System.out.println("y top = " + yrange[0]);
                if (right < numedges) {
                    System.out.println("y top of next curve = " + edgelist[right].getCurve().getYTop());
                } else {
                    System.out.println("no more curves");
                }
                for (cur = left; cur < right; ++cur) {
                    e = edgelist[cur];
                    System.out.println(e);
                    int eq = e.getEquivalence();
                    if (eq == 0) continue;
                    System.out.println("  was equal to " + eq + "...");
                }
            }
            chains = AreaOpX.resolveLinks(subcurves, chains, links);
            links.clear();
            yrange[0] = yend;
        }
        AreaOpX.finalizeSubCurves(subcurves, chains);
        int numlinks = subcurves.size();
        AreaXBody ret = new AreaXBody(null, numlinks);
        CurveLinkX[] linklist = subcurves.getArray();
        for (int i = 0; i < numlinks; ++i) {
            CurveLinkX link = linklist[i];
            ret.add(link.getMoveto());
            CurveLinkX nextlink = link;
            while ((nextlink = nextlink.getNext()) != null) {
                if (link.absorb(nextlink)) continue;
                ret.add(link.getSubCurve());
                link = nextlink;
            }
            ret.add(link.getSubCurve());
        }
        return ret;
    }

    public static void finalizeSubCurves(RawLinkArrayList subcurves, RawChainArrayList chains) {
        int numchains = chains.size();
        if (numchains == 0) {
            return;
        }
        if ((numchains & 1) != 0) {
            throw new InternalError("Odd number of chains!");
        }
        ChainEndX[] endlist = chains.getArray();
        for (int i = 1; i < numchains; i += 2) {
            ChainEndX open = endlist[i - 1];
            ChainEndX close = endlist[i];
            CurveLinkX subcurve = open.linkTo(close);
            if (subcurve == null) continue;
            subcurves.add(subcurve);
        }
        chains.clear();
    }

    private static RawChainArrayList resolveLinks(RawLinkArrayList subcurves, RawChainArrayList chains, RawLinkArrayList links) {
        int curchain = 0;
        int curlink = 0;
        int numlinks = links.size();
        int numchains = chains.size();
        links.ensureCapacity(numlinks + 2);
        chains.ensureCapacity(numchains + 2);
        CurveLinkX[] linklist = links.getArray();
        ChainEndX[] endlist = chains.getArray();
        ChainEndX chain = endlist[0];
        ChainEndX nextchain = endlist[1];
        CurveLinkX link = linklist[0];
        CurveLinkX nextlink = linklist[1];
        RawChainArrayList newChains = new RawChainArrayList(0);
        while (chain != null || link != null) {
            boolean connectlinks;
            boolean connectchains = link == null;
            boolean bl = connectlinks = chain == null;
            if (!connectchains && !connectlinks) {
                connectchains = !(curchain & true) && chain.getX() == nextchain.getX();
                boolean bl2 = connectlinks = !(curlink & true) && link.getX() == nextlink.getX();
                if (!connectchains && !connectlinks) {
                    double cx = chain.getX();
                    double lx = link.getX();
                    connectchains = nextchain != null && cx < lx && AreaOpX.obstructs(nextchain.getX(), lx, curchain);
                    boolean bl3 = connectlinks = nextlink != null && lx < cx && AreaOpX.obstructs(nextlink.getX(), cx, curlink);
                }
            }
            if (connectchains) {
                CurveLinkX subcurve = chain.linkTo(nextchain);
                if (subcurve != null) {
                    subcurves.add(subcurve);
                }
                chain = endlist[curchain += 2];
                nextchain = endlist[curchain + 1];
            }
            if (connectlinks) {
                ChainEndX openend = new ChainEndX(link, null);
                ChainEndX closeend = new ChainEndX(nextlink, openend);
                openend.setOtherEnd(closeend);
                newChains.add(openend);
                newChains.add(closeend);
                link = linklist[curlink += 2];
                nextlink = linklist[curlink + 1];
            }
            if (connectchains || connectlinks) continue;
            chain.addLink(link);
            newChains.add(chain);
            chain = nextchain;
            nextchain = endlist[++curchain + 1];
            link = nextlink;
            nextlink = linklist[++curlink + 1];
        }
        if ((newChains.size() & 1) != 0) {
            System.out.println("Odd number of chains!");
        }
        return newChains;
    }

    public static boolean obstructs(double v1, double v2, int phase) {
        return (phase & 1) == 0 ? v1 <= v2 : v1 < v2;
    }

    public static class EOWindOp
    extends AreaOpX {
        private boolean inside;

        @Override
        public void newRow() {
            this.inside = false;
        }

        @Override
        public int classify(EdgeX e) {
            boolean newInside;
            this.inside = newInside = !this.inside;
            return newInside ? 1 : -1;
        }

        @Override
        public int getState() {
            return this.inside ? 1 : -1;
        }
    }

    public static class NZWindOp
    extends AreaOpX {
        private int count;

        @Override
        public void newRow() {
            this.count = 0;
        }

        @Override
        public int classify(EdgeX e) {
            int newCount = this.count;
            int type = newCount == 0 ? 1 : 0;
            this.count = newCount += e.getCurve().getDirection();
            return newCount == 0 ? -1 : type;
        }

        @Override
        public int getState() {
            return this.count == 0 ? -1 : 1;
        }
    }

    public static class XorOp
    extends CAGOp {
        @Override
        public boolean newClassification(boolean inLeft, boolean inRight) {
            return inLeft != inRight;
        }
    }

    public static class IntOp
    extends CAGOp {
        @Override
        public boolean newClassification(boolean inLeft, boolean inRight) {
            return inLeft && inRight;
        }
    }

    public static class SubOp
    extends CAGOp {
        @Override
        public boolean newClassification(boolean inLeft, boolean inRight) {
            return inLeft && !inRight;
        }
    }

    public static class AddOp
    extends CAGOp {
        @Override
        public boolean newClassification(boolean inLeft, boolean inRight) {
            return inLeft || inRight;
        }
    }

    public static abstract class CAGOp
    extends AreaOpX {
        boolean inLeft;
        boolean inRight;
        boolean inResult;

        @Override
        public void newRow() {
            this.inLeft = false;
            this.inRight = false;
            this.inResult = false;
        }

        @Override
        public int classify(EdgeX e) {
            if (e.getCurveTag() == 0) {
                this.inLeft = !this.inLeft;
            } else {
                this.inRight = !this.inRight;
            }
            boolean newClass = this.newClassification(this.inLeft, this.inRight);
            if (this.inResult == newClass) {
                return 0;
            }
            this.inResult = newClass;
            return newClass ? 1 : -1;
        }

        @Override
        public int getState() {
            return this.inResult ? 1 : -1;
        }

        public abstract boolean newClassification(boolean var1, boolean var2);
    }
}

