package plugins.adufour.ij;

import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import icy.file.FileUtil;
import icy.imagej.ImageJUtil;
import icy.network.NetworkUtil;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import ij.gui.Roi;
import ij.io.RoiDecoder;
import plugins.adufour.blocks.tools.ij.IJBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.VarROIArray;

public class ImportROIFromIJ extends EzPlug implements IJBlock
{
    private enum PositionDimension
    {
        Z, T
    }
    
    EzVarFile inputFile = new EzVarFile("ImageJ ROI file (.zip)", null);
    EzVarEnum<PositionDimension> dim = new EzVarEnum<PositionDimension>("Dimension (if any)", PositionDimension.values());
    EzVarSequence inputSequence = new EzVarSequence("Add ROI to");
    
    VarROIArray output = new VarROIArray("ROI");
    
    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("input ROI file", inputFile.getVariable());
        inputMap.add("dimension", dim.getVariable());
    }
    
    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("ROI", output);
    }
    
    @Override
    public void clean()
    {
    }
    
    @Override
    protected void execute()
    {
        output.setValue(new ROI[0]);
        
        File f = inputFile.getValue(true);
        Sequence s = null;
        
        if (getUI() != null) s = inputSequence.getValue(true);
        
        if (FileUtil.getFileExtension(f.getPath(), false).endsWith("zip"))
        {
            try
            {
                ZipFile zip = new ZipFile(f);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements())
                {
                    ZipEntry entry = entries.nextElement();
                    byte[] data = NetworkUtil.download(zip.getInputStream(entry));
                    Roi ijROI = RoiDecoder.openFromByteArray(data);
                    
                    for (ROI2D roi : ImageJUtil.convertToIcyRoi(ijROI))
                        if (s != null)
                        {
                            s.addROI(roi);
                        }
                        else
                        {
                            output.add(roi);
                        }
                }
                
                zip.close();
            }
            catch (Exception e)
            {
                e.printStackTrace();
            }
        }
    }
    
    @Override
    protected void initialize()
    {
        addEzComponent(inputFile);
        addEzComponent(dim);
        addEzComponent(inputSequence);
    }
    
}
