/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.filtering;

import com.nativelibs4java.opencl.CLBuildException;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.JavaCL;
import com.ochafik.io.ReadText;
import icy.image.IcyBufferedImage;
import icy.plugin.PluginDescriptor;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.IcyHandledException;
import java.io.IOException;
import java.util.ArrayList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzException;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDimensionPicker;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarDoubleArrayNative;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarPlugin;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.filtering.Convolution;
import plugins.adufour.filtering.Convolution1D;
import plugins.adufour.filtering.ConvolutionCL;
import plugins.adufour.filtering.ConvolutionException;
import plugins.adufour.filtering.Filter;
import plugins.adufour.filtering.Kernels1D;
import plugins.adufour.filtering.Kernels2D;
import plugins.adufour.filtering.SelectionFilter;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.util.VarListener;

public class FilterToolbox
extends EzPlug
implements EzStoppable {
    private static final int MAX_KERNEL_SIZE = 99;
    public EzVarSequence input = new EzVarSequence("input");
    public EzVarEnum<FilterType> filterType = new EzVarEnum("Filter type", (Enum[])FilterType.values());
    public EzVarEnum<Kernels1D> kernel1D = new EzVarEnum("1D Kernels", (Enum[])Kernels1D.values());
    public EzVarBoolean linearSeparable = new EzVarBoolean("Separable", true);
    public EzVarBoolean linearX = new EzVarBoolean("Along X", true);
    public EzVarBoolean linearY = new EzVarBoolean("Along Y", true);
    public EzVarBoolean linearZ = new EzVarBoolean("Along Z", false);
    public EzVarDouble gaussianX = new EzVarDouble("Sigma X", 1.0, 0.0, 100.0, 0.1);
    public EzVarDouble gaussianY = new EzVarDouble("Sigma Y", 1.0, 0.0, 100.0, 0.1);
    public EzVarDouble gaussianZ = new EzVarDouble("Sigma Z", 1.0, 0.0, 100.0, 0.1);
    public EzVarEnum<Kernels2D> kernel2D = new EzVarEnum("2D Kernels", (Enum[])Kernels2D.values());
    public EzVarDouble gaborSigma = new EzVarDouble("Sigma", 0.0, 100.0, 0.1);
    public EzVarDouble gaborKx = new EzVarDouble("Kx", 0.0, 100.0, 0.1);
    public EzVarDouble gaborKy = new EzVarDouble("Ky", 0.0, 100.0, 0.1);
    public EzVarBoolean gaborSymmetric = new EzVarBoolean("Symmertric", true);
    public EzVarPlugin<SelectionFilter> selectionFilter = new EzVarPlugin("selection filter", SelectionFilter.class);
    public EzVarInteger selectionRadiusX = new EzVarInteger("Filter radius (X)", 1, 0, 99, 1);
    public EzVarInteger selectionRadiusY = new EzVarInteger("Filter radius (Y)", 1, 0, 99, 1);
    public EzVarInteger selectionRadiusZ = new EzVarInteger("Filter radius (Z)", 1, 0, 99, 1);
    public EzVarBoolean zeroEdge = new EzVarBoolean("Zero on edge", false);
    public EzVarInteger userKernelWidth = new EzVarInteger("kernel width", 3, 99, 2);
    public EzVarInteger userKernelHeight = new EzVarInteger("kernel height", 1, 99, 2);
    public ArrayList<EzVarDoubleArrayNative> kernelLines = new ArrayList(1);
    public EzVarSequence customKernel = new EzVarSequence("Kernel sequence");
    public EzVarDimensionPicker customKernel_T = new EzVarDimensionPicker("T", DimensionId.T, (Var)this.customKernel.getVariable());
    public EzVarDimensionPicker customKernel_Z = new EzVarDimensionPicker("Z", DimensionId.Z, (Var)this.customKernel.getVariable());
    public EzVarDimensionPicker customKernel_C = new EzVarDimensionPicker("C", DimensionId.C, (Var)this.customKernel.getVariable());
    public EzVarInteger iterations = new EzVarInteger("nb. iterations", 1, 1, 10000, 1);
    private ConvolutionCL convolutionCL;
    private CLContext context;
    private CLQueue queue;
    private CLProgram program;
    public EzVarBoolean useOpenCL = new EzVarBoolean("Use OpenCL", false);
    private VarBoolean stopFlag = new VarBoolean("stop", false);
    private Filter filter;

    public void initialize() {
        this.addEzComponent((EzComponent)this.input);
        this.input.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                if (newValue == null) {
                    return;
                }
                boolean is3D = newValue.getSizeZ() > 1;
                FilterToolbox.this.linearZ.setVisible(is3D);
                FilterToolbox.this.gaussianZ.setVisible(is3D);
                FilterToolbox.this.selectionRadiusZ.setVisible(is3D);
            }
        });
        this.input.valueChanged((Var)this.input.getVariable(), null, this.input.getValue());
        this.addEzComponent((EzComponent)this.filterType);
        this.addEzComponent((EzComponent)this.iterations);
        try {
            this.useOpenCL.addVarChangeListener((EzVarListener)new EzVarListener<Boolean>(){

                public void variableChanged(EzVar<Boolean> source, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        FilterToolbox.this.linearZ.setVisible(false);
                        FilterToolbox.this.gaussianZ.setVisible(false);
                    }
                }
            });
            this.useOpenCL.setVisible(false);
            this.context = JavaCL.createBestContext();
            this.queue = this.context.createDefaultQueue(new CLDevice.QueueProperties[0]);
            String programFile = ReadText.readText(ConvolutionCL.class.getResourceAsStream("Convolution.cl"));
            this.program = this.context.createProgram(programFile).build();
            this.convolutionCL = new ConvolutionCL(this.context, this.program, this.queue);
            this.useOpenCL.setValue((Object)true);
            this.useOpenCL.setVisible(true);
        }
        catch (IOException e) {
            System.out.println("Warning (FilterToolbox): unable to load the OpenCL code. Continuing in pure Java mode.");
            e.printStackTrace();
        }
        catch (CLBuildException e) {
            System.out.println("Warning (FilterToolbox): unable to create the OpenCL context. Continuing in pure Java mode.");
            e.printStackTrace();
        }
        catch (CLException e) {
            System.out.println("Warning (FilterToolbox): unable to create the OpenCL context. Continuing in pure Java mode.");
            e.printStackTrace();
        }
        catch (NoClassDefFoundError e) {
            System.out.println("Warning (FilterToolbox): unable to create the OpenCL context. Continuing in pure Java mode.");
            e.printStackTrace();
        }
        catch (UnsatisfiedLinkError linkError) {
            System.out.println("Warning (FilterToolbox): OpenCL drivers not found. Using basic Java implementation.");
        }
        this.filterType.addVisibilityTriggerTo((EzComponent)this.useOpenCL, (Object[])new FilterType[]{FilterType.CLASSIC, FilterType.SEPARABLE});
        this.filterType.addVisibilityTriggerTo((EzComponent)this.iterations, (Object[])new FilterType[]{FilterType.CLASSIC, FilterType.SEPARABLE});
        this.addEzComponent((EzComponent)this.kernel1D);
        this.filterType.addVisibilityTriggerTo(this.kernel1D, (Object[])new FilterType[]{FilterType.SEPARABLE});
        EzGroup groupLinear = new EzGroup("Directions", new EzComponent[]{this.linearX, this.linearY, this.linearZ, this.linearSeparable});
        this.addEzComponent((EzComponent)groupLinear);
        this.filterType.addVisibilityTriggerTo((EzComponent)groupLinear, (Object[])new FilterType[]{FilterType.SEPARABLE});
        this.kernel1D.addVisibilityTriggerTo((EzComponent)this.linearSeparable, (Object[])new Kernels1D[]{Kernels1D.CUSTOM});
        this.useOpenCL.addVisibilityTriggerTo((EzComponent)this.linearZ, (Object[])new Boolean[]{false});
        EzGroup groupGaussian = new EzGroup("Gaussian filter", new EzComponent[]{this.gaussianX, this.gaussianY, this.gaussianZ});
        this.addEzComponent((EzComponent)groupGaussian);
        this.kernel1D.addVisibilityTriggerTo((EzComponent)groupGaussian, (Object[])new Kernels1D[]{Kernels1D.CUSTOM_GAUSSIAN});
        this.useOpenCL.addVisibilityTriggerTo((EzComponent)this.gaussianZ, (Object[])new Boolean[]{false});
        this.addEzComponent((EzComponent)this.kernel2D);
        this.filterType.addVisibilityTriggerTo(this.kernel2D, (Object[])new FilterType[]{FilterType.CLASSIC});
        EzGroup gaborGroup = new EzGroup("Gabor 2D", new EzComponent[]{this.gaborSigma, this.gaborKx, this.gaborKy, this.gaborSymmetric});
        this.addEzComponent((EzComponent)gaborGroup);
        this.kernel2D.addVisibilityTriggerTo((EzComponent)gaborGroup, (Object[])new Kernels2D[]{Kernels2D.CUSTOM_GABOR});
        EzGroup customSequenceGroup = new EzGroup("Custom sequence", new EzComponent[]{this.customKernel, this.customKernel_T, this.customKernel_Z, this.customKernel_C});
        this.addEzComponent((EzComponent)customSequenceGroup);
        this.kernel2D.addVisibilityTriggerTo((EzComponent)customSequenceGroup, (Object[])new Kernels2D[]{Kernels2D.CUSTOM_SEQUENCE});
        EzGroup groupSelection = new EzGroup("Selection filter", new EzComponent[]{this.selectionFilter, this.selectionRadiusX, this.selectionRadiusY, this.selectionRadiusZ});
        this.addEzComponent((EzComponent)groupSelection);
        this.filterType.addVisibilityTriggerTo((EzComponent)groupSelection, (Object[])new FilterType[]{FilterType.SELECTION});
        this.addEzComponent((EzComponent)this.zeroEdge);
        this.filterType.addVisibilityTriggerTo((EzComponent)this.zeroEdge, (Object[])new FilterType[]{FilterType.CLASSIC, FilterType.SEPARABLE});
        this.addEzComponent((EzComponent)this.userKernelWidth);
        this.kernel1D.addVisibilityTriggerTo((EzComponent)this.userKernelWidth, (Object[])new Kernels1D[]{Kernels1D.CUSTOM});
        this.kernel2D.addVisibilityTriggerTo((EzComponent)this.userKernelWidth, (Object[])new Kernels2D[]{Kernels2D.CUSTOM});
        this.addEzComponent((EzComponent)this.userKernelHeight);
        this.kernel2D.addVisibilityTriggerTo((EzComponent)this.userKernelHeight, (Object[])new Kernels2D[]{Kernels2D.CUSTOM});
        EzVarDoubleArrayNative firstKernelLine = new EzVarDoubleArrayNative("Line 1", (double[][])new double[][]{{1.0, 1.0, 1.0}}, 0, true);
        this.kernelLines.add(firstKernelLine);
        this.addEzComponent((EzComponent)firstKernelLine);
        this.kernel1D.addVisibilityTriggerTo((EzComponent)firstKernelLine, (Object[])new Kernels1D[]{Kernels1D.CUSTOM});
        this.kernel2D.addVisibilityTriggerTo((EzComponent)firstKernelLine, (Object[])new Kernels2D[]{Kernels2D.CUSTOM});
        this.userKernelHeight.addVarChangeListener((EzVarListener)new EzVarListener<Integer>(){

            public void variableChanged(EzVar<Integer> source, Integer newValue) {
                if (FilterToolbox.this.kernelLines.size() < newValue) {
                    int nbLines = FilterToolbox.this.kernelLines.size();
                    int nbNewLines = newValue - nbLines;
                    for (int i = 1; i <= nbNewLines; ++i) {
                        int lineNumber = i + nbLines;
                        EzVarDoubleArrayNative newLine = new EzVarDoubleArrayNative("Line " + lineNumber, (double[][])new double[][]{{1.0, 1.0, 1.0}}, 0, true);
                        FilterToolbox.this.kernelLines.add(newLine);
                        FilterToolbox.this.kernel2D.addVisibilityTriggerTo((EzComponent)newLine, (Object[])new Kernels2D[]{Kernels2D.CUSTOM});
                        FilterToolbox.this.addEzComponent((EzComponent)newLine);
                    }
                } else if (FilterToolbox.this.userKernelHeight.isVisible()) {
                    for (int i = 0; i < FilterToolbox.this.kernelLines.size(); ++i) {
                        FilterToolbox.this.kernelLines.get(i).setVisible(i < newValue);
                    }
                }
                if (FilterToolbox.this.getUI() != null) {
                    FilterToolbox.this.getUI().repack(true);
                }
            }
        });
        this.setTimeDisplay(true);
    }

    public void execute() {
        this.stopFlag.setValue((Object)false);
        Sequence inSeq = (Sequence)this.input.getValue(true);
        try {
            switch ((FilterType)((Object)this.filterType.getValue())) {
                case SEPARABLE: {
                    this.executeSeparable(inSeq);
                    break;
                }
                case CLASSIC: {
                    this.executeClassic(inSeq);
                    break;
                }
                case SELECTION: {
                    try {
                        this.executeSelectionFilter(inSeq);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        catch (CLException.OutOfHostMemory o) {
            throw new IcyHandledException("Not enough memory to perform the filtering on the GPU. Disable OpenCL and retry.");
        }
    }

    private void executeSelectionFilter(Sequence inSeq) throws InstantiationException, IllegalAccessException {
        SelectionFilter filter = (SelectionFilter)((Object)((PluginDescriptor)this.selectionFilter.getValue()).getPluginClass().newInstance());
        this.filter = filter;
        filter.progress.addListener((VarListener)new VarListener<Double>(){

            public void valueChanged(Var<Double> source, Double oldValue, Double newValue) {
                FilterToolbox.this.getUI().setProgressBarValue(newValue.doubleValue());
            }

            public void referenceChanged(Var<Double> source, Var<? extends Double> oldReference, Var<? extends Double> newReference) {
            }
        });
        Sequence out = inSeq;
        for (int i = 0; i < (Integer)this.iterations.getValue(); ++i) {
            out = filter.filterSquare(out, (Integer)this.selectionRadiusX.getValue(), (Integer)this.selectionRadiusY.getValue(), (Integer)this.selectionRadiusZ.getValue());
            if (((Boolean)this.stopFlag.getValue()).booleanValue()) break;
        }
        this.addSequence(out);
        filter.progress.removeListeners();
        this.filter = null;
    }

    private void executeClassic(Sequence inSeq) {
        Kernels2D k2d = (Kernels2D)this.kernel2D.getValue();
        switch ((Kernels2D)this.kernel2D.getValue()) {
            case CUSTOM_GABOR: {
                k2d.createGaborKernel2D((Double)this.gaborSigma.getValue(), (Double)this.gaborKx.getValue(), (Double)this.gaborKy.getValue(), (Boolean)this.gaborSymmetric.getValue());
                break;
            }
            case CUSTOM: {
                ArrayList<Double> kernel1D = new ArrayList<Double>();
                for (int i = 0; i < (Integer)this.userKernelHeight.getValue(); ++i) {
                    for (double d : (double[])this.kernelLines.get(i).getValue()) {
                        kernel1D.add(d);
                    }
                }
                double[] values = new double[kernel1D.size()];
                for (int i = 0; i < kernel1D.size(); ++i) {
                    values[i] = (Double)kernel1D.get(i);
                }
                k2d.createCustomKernel2D(values, (int)((Integer)this.userKernelWidth.getValue()), (int)((Integer)this.userKernelHeight.getValue()), false);
                break;
            }
            case CUSTOM_SEQUENCE: {
                k2d.createCustomKernel2D((Sequence)this.customKernel.getValue(true), (int)((Integer)this.customKernel_T.getValue()), (int)((Integer)this.customKernel_Z.getValue()), (Integer)this.customKernel_C.getValue());
                break;
            }
        }
        Sequence kernel = k2d.toSequence();
        Sequence output = null;
        boolean openCL_failed = false;
        if (((Boolean)this.useOpenCL.getValue()).booleanValue()) {
            try {
                output = SequenceUtil.getCopy((Sequence)inSeq);
                this.convolutionCL.convolve(output, kernel, (Boolean)this.zeroEdge.getValue(), (Integer)this.iterations.getValue(), this.stopFlag);
                openCL_failed = false;
            }
            catch (Exception e) {
                openCL_failed = true;
                e.printStackTrace();
                System.err.println("WARNING: Unable to run in OpenCL mode. Switching to CPU mode.");
            }
        }
        if (!((Boolean)this.useOpenCL.getValue()).booleanValue() || openCL_failed) {
            Convolution c = new Convolution();
            this.filter = c;
            VarListener<Double> ld = new VarListener<Double>(){

                public void valueChanged(Var<Double> source, Double oldValue, Double newValue) {
                    FilterToolbox.this.getUI().setProgressBarValue(newValue.doubleValue());
                }

                public void referenceChanged(Var<Double> source, Var<? extends Double> oldReference, Var<? extends Double> newReference) {
                }
            };
            c.progress.addListener((VarListener)ld);
            output = c.convolve((Sequence)this.input.getValue(true), kernel, (Boolean)this.zeroEdge.getValue(), (Integer)this.iterations.getValue());
            c.progress.removeListener((VarListener)ld);
            this.filter = null;
        }
        output.setName(inSeq.getName() + " * " + kernel.getName());
        output.updateChannelsBounds(true);
        this.addSequence(output);
    }

    private void executeSeparable(Sequence inSeq) {
        String newName;
        Sequence output;
        Kernels1D k1d = (Kernels1D)this.kernel1D.getValue();
        Sequence kernelX = null;
        Sequence kernelY = null;
        Sequence kernelZ = null;
        int nbDirections = 0;
        switch (k1d) {
            case CUSTOM_GAUSSIAN: {
                this.linearSeparable.setValue((Object)true);
                if (((Boolean)this.linearX.getValue()).booleanValue() && (Double)this.gaussianX.getValue() > 1.0E-10) {
                    kernelX = k1d.createGaussianKernel1D((Double)this.gaussianX.getValue()).toSequence();
                    ++nbDirections;
                }
                if (((Boolean)this.linearY.getValue()).booleanValue() && (Double)this.gaussianY.getValue() > 1.0E-10) {
                    kernelY = k1d.createGaussianKernel1D((Double)this.gaussianY.getValue()).toSequence();
                    ++nbDirections;
                }
                if (!((Boolean)this.linearZ.getValue()).booleanValue() || !((Double)this.gaussianZ.getValue() > 1.0E-10)) break;
                kernelZ = k1d.createGaussianKernel1D((Double)this.gaussianZ.getValue()).toSequence();
                ++nbDirections;
                break;
            }
            case GRADIENT: {
                this.linearSeparable.setValue((Object)false);
                Sequence kernel = k1d.toSequence();
                if (((Boolean)this.linearX.getValue()).booleanValue()) {
                    kernelX = kernel;
                    ++nbDirections;
                }
                if (((Boolean)this.linearY.getValue()).booleanValue()) {
                    kernelY = kernel;
                    ++nbDirections;
                }
                if (!((Boolean)this.linearZ.getValue()).booleanValue()) break;
                kernelZ = kernel;
                ++nbDirections;
                break;
            }
            case CUSTOM: {
                Sequence kernel = k1d.createCustomKernel1D((double[])this.kernelLines.get(0).getValue(), false).toSequence();
                if (((Boolean)this.linearX.getValue()).booleanValue()) {
                    kernelX = kernel;
                    ++nbDirections;
                }
                if (((Boolean)this.linearY.getValue()).booleanValue()) {
                    kernelY = kernel;
                    ++nbDirections;
                }
                if (!((Boolean)this.linearZ.getValue()).booleanValue()) break;
                kernelZ = kernel;
                ++nbDirections;
            }
        }
        if (nbDirections == 0) {
            throw new IcyHandledException("Filter toolbox: no direction selected");
        }
        boolean openCL_failed = false;
        if (((Boolean)this.useOpenCL.getValue()).booleanValue()) {
            if (((Boolean)this.linearZ.getValue()).booleanValue()) {
                System.out.println("Warning: unable to use OpenCL for a convolution along the Z axis, continuing in CPU mode");
                openCL_failed = true;
            } else {
                try {
                    if (((Boolean)this.linearSeparable.getValue()).booleanValue()) {
                        output = SequenceUtil.getCopy((Sequence)inSeq);
                        newName = output.getName() + " * " + k1d.name() + " (";
                        if (((Boolean)this.linearX.getValue()).booleanValue()) {
                            this.convolutionCL.convolve(output, kernelX, (Boolean)this.zeroEdge.getValue(), (Integer)this.iterations.getValue(), this.stopFlag);
                            newName = newName + 'X';
                        }
                        if (((Boolean)this.linearY.getValue()).booleanValue()) {
                            Sequence kernelY_vertical = new Sequence(new IcyBufferedImage(1, kernelY.getSizeX(), 1, kernelY.getDataType_()));
                            System.arraycopy(kernelY.getDataXY(0, 0, 0), 0, kernelY_vertical.getDataXY(0, 0, 0), 0, kernelY.getSizeX());
                            this.convolutionCL.convolve(output, kernelY_vertical, (Boolean)this.zeroEdge.getValue(), (Integer)this.iterations.getValue(), this.stopFlag);
                            newName = newName + 'Y';
                        }
                        output.setName(newName + ")");
                        output.dataChanged();
                        this.addSequence(output);
                    } else {
                        if (((Boolean)this.linearX.getValue()).booleanValue()) {
                            output = SequenceUtil.getCopy((Sequence)inSeq);
                            this.convolutionCL.convolve(output, kernelX, (Boolean)this.zeroEdge.getValue(), (Integer)this.iterations.getValue(), this.stopFlag);
                            output.setName(output.getName() + " * " + k1d.name() + " (X)");
                            output.dataChanged();
                            this.addSequence(output);
                        }
                        if (((Boolean)this.linearY.getValue()).booleanValue()) {
                            output = SequenceUtil.getCopy((Sequence)inSeq);
                            Sequence kernelY_vertical = new Sequence(new IcyBufferedImage(1, kernelY.getSizeX(), 1, kernelY.getDataType_()));
                            System.arraycopy(kernelY.getDataXY(0, 0, 0), 0, kernelY_vertical.getDataXY(0, 0, 0), 0, kernelY.getSizeX());
                            this.convolutionCL.convolve(output, kernelY_vertical, (Boolean)this.zeroEdge.getValue(), (Integer)this.iterations.getValue(), this.stopFlag);
                            output.setName(output.getName() + " * " + k1d.name() + " (Y)");
                            output.dataChanged();
                            this.addSequence(output);
                        }
                    }
                }
                catch (Exception e) {
                    openCL_failed = true;
                    e.printStackTrace();
                    System.err.println("WARNING: Unable to run in OpenCL mode. Continuing in CPU mode.");
                }
            }
        }
        if (!((Boolean)this.useOpenCL.getValue()).booleanValue() || openCL_failed) {
            if (((Boolean)this.linearSeparable.getValue()).booleanValue()) {
                try {
                    output = SequenceUtil.getCopy((Sequence)inSeq);
                    Convolution1D.convolve(output, kernelX, kernelY, kernelZ, (Integer)this.iterations.getValue(), this.stopFlag);
                    newName = output.getName() + " * " + k1d.name() + " (";
                    if (kernelX != null) {
                        newName = newName + 'X';
                    }
                    if (kernelY != null) {
                        newName = newName + 'Y';
                    }
                    if (kernelZ != null) {
                        newName = newName + 'Z';
                    }
                    output.setName(newName + ')');
                    output.dataChanged();
                    this.addSequence(output);
                }
                catch (ConvolutionException e) {
                    throw new EzException((EzPlug)this, e.getMessage(), true);
                }
            }
            if (((Boolean)this.linearX.getValue()).booleanValue()) {
                try {
                    output = SequenceUtil.getCopy((Sequence)inSeq);
                    Convolution1D.convolve(output, kernelX, null, null, (Integer)this.iterations.getValue(), this.stopFlag);
                    output.setName(output.getName() + " * " + k1d.name() + " (X)");
                    output.dataChanged();
                    this.addSequence(output);
                }
                catch (ConvolutionException e) {
                    throw new EzException((EzPlug)this, e.getMessage(), true);
                }
            }
            if (((Boolean)this.linearY.getValue()).booleanValue()) {
                try {
                    output = SequenceUtil.getCopy((Sequence)inSeq);
                    Convolution1D.convolve(output, null, kernelY, null, (Integer)this.iterations.getValue(), this.stopFlag);
                    output.setName(output.getName() + " * " + k1d.name() + " (Y)");
                    output.dataChanged();
                    this.addSequence(output);
                }
                catch (ConvolutionException e) {
                    throw new EzException((EzPlug)this, e.getMessage(), true);
                }
            }
            if (((Boolean)this.linearZ.getValue()).booleanValue()) {
                try {
                    output = SequenceUtil.getCopy((Sequence)inSeq);
                    Convolution1D.convolve(output, null, null, kernelZ, (Integer)this.iterations.getValue(), this.stopFlag);
                    output.setName(output.getName() + " * " + k1d.name() + " (Z)");
                    output.dataChanged();
                    this.addSequence(output);
                }
                catch (ConvolutionException e) {
                    throw new EzException((EzPlug)this, e.getMessage(), true);
                }
            }
        }
    }

    public void clean() {
        if (((Boolean)this.useOpenCL.getValue()).booleanValue()) {
            if (this.queue != null) {
                this.queue.release();
            }
            if (this.context != null) {
                this.context.release();
            }
        }
    }

    public void stopExecution() {
        this.stopFlag.setValue((Object)true);
        if (this.filter != null) {
            this.filter.stopFlag.setValue((Object)true);
        }
    }

    public static enum FilterType {
        CLASSIC,
        SEPARABLE,
        SELECTION;

    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

