/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.error.ellipse.rigid.dimension3;

import Jama.Matrix;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.error.ellipse.rigid.InverseFisherInformationMatrixEstimator;
import plugins.perrine.ec_clem.ec_clem.error.ellipse.rigid.dimension3.RotationParameters3D;
import plugins.perrine.ec_clem.ec_clem.fiducialset.FiducialSet;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.matrix.MatrixUtil;
import plugins.perrine.ec_clem.ec_clem.registration.RegistrationParameter;
import plugins.perrine.ec_clem.ec_clem.transformation.Similarity;

public class InverseFisherInformationMatrix3DEstimator
extends InverseFisherInformationMatrixEstimator {
    private RotationParameters3D rotationParameters3D;

    @Inject
    public InverseFisherInformationMatrix3DEstimator(MatrixUtil matrixUtil, RotationParameters3D rotationParameters3D) {
        super(matrixUtil);
        this.rotationParameters3D = rotationParameters3D;
    }

    @Override
    protected int getNParameters() {
        return 6;
    }

    @Override
    protected Matrix getX(FiducialSet fiducialSet, RegistrationParameter registrationParameter, int n) {
        return fiducialSet.getTargetDataset().getPoint(n).minus(registrationParameter.getTransformation().apply(fiducialSet.getSourceDataset().getPoint(n))).getMatrix();
    }

    @Override
    protected Matrix getGradientX(FiducialSet fiducialSet, RegistrationParameter registrationParameter, int n, int i) {
        switch (i) {
            case 0: {
                return new Matrix((double[][])new double[][]{{-1.0}, {0.0}, {0.0}});
            }
            case 1: {
                return new Matrix((double[][])new double[][]{{0.0}, {-1.0}, {0.0}});
            }
            case 2: {
                return new Matrix((double[][])new double[][]{{0.0}, {0.0}, {-1.0}});
            }
            case 3: {
                Point z = fiducialSet.getSourceDataset().getPoint(n);
                double[] eulerParameters = this.rotationParameters3D.getZYZEulerParameters((Similarity)registrationParameter.getTransformation());
                double alpha = eulerParameters[0];
                double beta = eulerParameters[1];
                double gamma = eulerParameters[2];
                return new Matrix((double[][])new double[][]{{z.get(0) * (Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma)) + z.get(1) * (-Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma)) + z.get(2) * (Math.sin(alpha) * Math.sin(beta))}, {z.get(0) * (-Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.sin(alpha) * Math.sin(gamma)) + z.get(1) * (Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.sin(alpha) * Math.cos(gamma)) + z.get(2) * (-Math.cos(alpha) * Math.sin(beta))}, {0.0}});
            }
            case 4: {
                Point z = fiducialSet.getSourceDataset().getPoint(n);
                double[] eulerParameters = this.rotationParameters3D.getZYZEulerParameters((Similarity)registrationParameter.getTransformation());
                double alpha = eulerParameters[0];
                double beta = eulerParameters[1];
                double gamma = eulerParameters[2];
                return new Matrix((double[][])new double[][]{{z.get(0) * (Math.sin(beta) * Math.cos(alpha) * Math.cos(gamma)) + z.get(1) * (-Math.sin(beta) * Math.cos(alpha) * Math.sin(gamma)) + z.get(2) * (-Math.cos(alpha) * Math.cos(beta))}, {z.get(0) * (Math.sin(alpha) * Math.sin(beta) * Math.cos(gamma)) + z.get(1) * (Math.sin(alpha) * -Math.sin(beta) * Math.sin(gamma)) + z.get(2) * (-Math.sin(alpha) * Math.cos(beta))}, {z.get(0) * Math.cos(beta * Math.cos(gamma)) + z.get(1) * (-Math.cos(beta) * Math.sin(gamma)) + z.get(2) * Math.sin(beta)}});
            }
            case 5: {
                Point z = fiducialSet.getSourceDataset().getPoint(n);
                double[] eulerParameters = this.rotationParameters3D.getZYZEulerParameters((Similarity)registrationParameter.getTransformation());
                double alpha = eulerParameters[0];
                double beta = eulerParameters[1];
                double gamma = eulerParameters[2];
                return new Matrix((double[][])new double[][]{{z.get(0) * (Math.sin(gamma) * Math.cos(alpha) * Math.cos(beta) + Math.sin(alpha) * Math.cos(gamma)) + z.get(1) * (Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma))}, {z.get(0) * (Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.cos(alpha) * Math.cos(gamma)) + z.get(1) * (Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.cos(alpha) * -Math.sin(gamma))}, {z.get(0) * (Math.sin(beta) * -Math.sin(gamma)) + z.get(1) * (-Math.sin(beta) * Math.cos(gamma))}});
            }
        }
        throw new RuntimeException("Only 3 parameters in rigid 2D");
    }

    @Override
    protected Matrix getHessianX(FiducialSet fiducialSet, RegistrationParameter registrationParameter, int n, int i, int j) {
        if (i == 0 || i == 1 || i == 2 || j == 0 || j == 1 || j == 2) {
            return new Matrix((double[][])new double[][]{{0.0}, {0.0}, {0.0}});
        }
        Point z = fiducialSet.getSourceDataset().getPoint(n);
        double[] eulerParameters = this.rotationParameters3D.getZYZEulerParameters((Similarity)registrationParameter.getTransformation());
        double alpha = eulerParameters[0];
        double beta = eulerParameters[1];
        double gamma = eulerParameters[2];
        if (i == 3 && j == 3) {
            return new Matrix((double[][])new double[][]{{z.get(0) * (Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma)) + z.get(1) * (-Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.sin(alpha) * Math.cos(gamma)) + z.get(2) * (Math.cos(alpha) * Math.sin(beta))}, {z.get(0) * (Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma)) + z.get(1) * (-Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma)) + z.get(2) * (Math.sin(alpha) * Math.sin(beta))}, {0.0}});
        }
        if (i == 3 && j == 4 || i == 4 && j == 3) {
            return new Matrix((double[][])new double[][]{{z.get(0) * (-Math.sin(alpha) * Math.sin(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma)) + z.get(1) * (Math.sin(alpha) * Math.sin(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma)) + z.get(2) * (Math.sin(alpha) * Math.cos(beta))}, {z.get(0) * (Math.cos(alpha) * Math.sin(beta) * Math.cos(gamma) + Math.sin(alpha) * Math.sin(gamma)) + z.get(1) * (-Math.cos(alpha) * Math.sin(beta) * Math.sin(gamma) + Math.sin(alpha) * Math.cos(gamma)) + z.get(2) * (-Math.cos(alpha) * Math.cos(beta))}, {0.0}});
        }
        if (i == 3 && j == 5 || i == 5 && j == 3) {
            return new Matrix((double[][])new double[][]{{z.get(0) * (-Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma)) + z.get(1) * (-Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.cos(alpha) * Math.sin(gamma))}, {z.get(0) * (Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.sin(alpha) * Math.cos(gamma)) + z.get(1) * (Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma))}, {0.0}});
        }
        if (i == 4 && j == 4) {
            return new Matrix((double[][])new double[][]{{z.get(0) * (Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma)) + z.get(1) * (-Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma)) + z.get(2) * (Math.cos(alpha) * Math.sin(beta))}, {z.get(0) * (Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma)) + z.get(1) * (-Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma)) + z.get(2) * (Math.sin(alpha) * Math.sin(beta))}, {z.get(0) * (-Math.sin(beta) * Math.cos(gamma)) + z.get(1) * (Math.sin(beta) * Math.sin(gamma)) + z.get(2) * Math.cos(beta)}});
        }
        if (i == 4 && j == 5 || i == 5 && j == 4) {
            return new Matrix((double[][])new double[][]{{z.get(0) * (-Math.cos(alpha) * Math.sin(beta) * Math.sin(gamma)) + z.get(1) * (-Math.cos(alpha) * Math.sin(beta) * Math.cos(gamma))}, {z.get(0) * (-Math.sin(alpha) * Math.sin(beta) * Math.sin(gamma)) + z.get(1) * (-Math.sin(alpha) * Math.sin(beta) * Math.cos(gamma))}, {z.get(0) * (-Math.cos(beta) * Math.sin(gamma)) + z.get(1) * (-Math.cos(beta) * Math.cos(gamma))}});
        }
        if (i == 5 && j == 5) {
            return new Matrix((double[][])new double[][]{{z.get(0) * (Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma)) + z.get(1) * (-Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.sin(alpha) * Math.cos(gamma))}, {z.get(0) * (Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma)) + z.get(1) * (-Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma))}, {z.get(0) * (-Math.sin(beta) * Math.cos(gamma)) + z.get(1) * (Math.sin(beta) * Math.sin(gamma))}});
        }
        throw new RuntimeException("Cas not implemented");
    }
}

