/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.error.ellipse.rigid.dimension3;

import Jama.Matrix;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.transformation.Similarity;

public class RotationParameters3D {
    @Inject
    public RotationParameters3D() {
    }

    public double[] getZYXEulerParameters(Similarity similarity) {
        if (similarity.getR().getRowDimension() != similarity.getR().getColumnDimension() || similarity.getR().getColumnDimension() != 3) {
            throw new RuntimeException("Use this class with 3D rotations");
        }
        double alpha = Math.atan2(similarity.getR().get(1, 0), similarity.getR().get(0, 0));
        double beta = Math.atan2(-1.0 * similarity.getR().get(2, 0), Math.sqrt(Math.pow(similarity.getR().get(0, 0), 2.0) + Math.pow(similarity.getR().get(1, 0), 2.0)));
        double gamma = Math.atan2(similarity.getR().get(2, 1), similarity.getR().get(2, 2));
        return new double[]{alpha, beta, gamma};
    }

    public double[] getZYZEulerParameters(Similarity similarity) {
        if (similarity.getR().getRowDimension() != similarity.getR().getColumnDimension() || similarity.getR().getColumnDimension() != 3) {
            throw new RuntimeException("Use this class with 3D rotations");
        }
        Matrix R = similarity.getR();
        double alpha = Math.atan2(R.get(1, 2), R.get(0, 2));
        double gamma = Math.atan2(R.get(2, 1), -1.0 * R.get(2, 0));
        double beta = Math.atan2(R.get(2, 1), Math.sin(gamma) * R.get(2, 2));
        return new double[]{alpha, beta, gamma};
    }
}

