/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.fiducialset.dataset;

import Jama.Matrix;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;

public class Dataset
implements Cloneable {
    private PointType pointType;
    private Matrix points;
    private int dimension;
    private int n;
    private Mean mean = new Mean();

    public Dataset(int dimension, PointType pointType) {
        this.pointType = pointType;
        this.dimension = dimension;
        this.n = 0;
        this.points = new Matrix(this.n, dimension);
    }

    public Dataset(Matrix M, PointType pointType) {
        this.pointType = pointType;
        this.dimension = M.getColumnDimension();
        this.n = M.getRowDimension();
        this.points = M;
    }

    public Dataset(List<Point> points, PointType pointType) {
        this.pointType = pointType;
        this.n = points.size();
        this.dimension = points.get(0).getDimension();
        this.points = new Matrix(this.n, this.dimension);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                this.points.set(i, j, points.get(i).getMatrix().get(j, 0));
            }
        }
    }

    public Dataset(double[][] points, PointType pointType) {
        this.pointType = pointType;
        this.n = points.length;
        this.dimension = points[0].length;
        this.points = new Matrix(points);
    }

    private boolean checkcoplanarity(double[][] points) {
        boolean check = true;
        if (points[0].length > 2) {
            double prev = points[0][2];
            for (int i = 1; i < points.length; ++i) {
                if (prev == points[i][2]) continue;
                check = false;
                break;
            }
        } else {
            check = false;
        }
        return check;
    }

    public Dataset clone() {
        Dataset clone = null;
        try {
            clone = (Dataset)super.clone();
            clone.points = this.points.copy();
            clone.mean = this.mean.copy();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public Point getBarycentre() {
        Matrix barycentre = new Matrix(this.dimension, 1);
        for (int i = 0; i < this.dimension; ++i) {
            this.mean.clear();
            for (int j = 0; j < this.n; ++j) {
                this.mean.increment(this.points.get(j, i));
            }
            barycentre.set(i, 0, this.mean.getResult());
        }
        return new Point(barycentre);
    }

    public void substractBarycentre() {
        this.substractRowWise(this.getBarycentre());
    }

    public double getMeanNorm() {
        this.mean.clear();
        for (int i = 0; i < this.n; ++i) {
            this.mean.increment(Math.sqrt(this.getPoint(i).getSumOfSquare()));
        }
        return this.mean.getResult();
    }

    public void substractRowWise(Point point) {
        for (int j = 0; j < this.dimension; ++j) {
            for (int i = 0; i < this.n; ++i) {
                this.points.set(i, j, this.points.get(i, j) - point.getMatrix().get(j, 0));
            }
        }
    }

    public Matrix getMatrix() {
        return this.points;
    }

    public Matrix getHomogeneousMatrixRight() {
        Matrix M = new Matrix(this.points.getRowDimension(), this.points.getColumnDimension() + 1, 1.0);
        M.setMatrix(0, this.points.getRowDimension() - 1, 0, this.points.getColumnDimension() - 1, this.points);
        return M;
    }

    public Matrix getHomogeneousMatrixLeft() {
        Matrix M = new Matrix(this.points.getRowDimension(), this.points.getColumnDimension() + 1, 1.0);
        M.setMatrix(0, this.points.getRowDimension() - 1, 1, this.points.getColumnDimension(), this.points);
        return M;
    }

    public int getN() {
        return this.n;
    }

    public int getDimension() {
        return this.dimension;
    }

    public Point getPoint(int i) {
        return new Point(this.points.getMatrix(i, i, 0, this.dimension - 1).getRowPackedCopy());
    }

    public Dataset setPoint(int i, Point point) {
        this.points.setMatrix(i, i, 0, this.dimension - 1, point.getMatrix().transpose());
        return this;
    }

    public Point removePoint(int i) {
        Point toRemove = this.getPoint(i);
        this.points = this.points.getMatrix(IntStream.range(0, this.n).filter(index -> index != i).toArray(), 0, this.dimension - 1);
        this.n = this.points.getRowDimension();
        return toRemove;
    }

    public Dataset addPoint(Point point) {
        Matrix M = new Matrix(this.n + 1, this.dimension);
        M.setMatrix(0, this.n - 1, 0, this.dimension - 1, this.points);
        M.setMatrix(this.n, this.n, 0, point.getDimension() - 1, point.getMatrix().transpose());
        this.points = M;
        this.n = this.points.getRowDimension();
        return this;
    }

    public Dataset addPoint(Point point, int i) {
        Matrix M = new Matrix(this.n + 1, this.dimension);
        if (i == 0) {
            M.setMatrix(0, 0, 0, point.getDimension() - 1, point.getMatrix().transpose());
            M.setMatrix(1, this.n, 0, this.dimension - 1, this.points);
        } else if (i == this.n + 1) {
            M.setMatrix(0, this.n - 1, 0, this.dimension - 1, this.points);
            M.setMatrix(this.n, this.n, 0, point.getDimension() - 1, point.getMatrix().transpose());
        } else {
            M.setMatrix(0, i - 1, 0, this.dimension - 1, this.points.getMatrix(0, i - 1, 0, this.dimension - 1));
            M.setMatrix(i, i, 0, point.getDimension() - 1, point.getMatrix().transpose());
            M.setMatrix(i + 1, this.n, 0, this.dimension - 1, this.points.getMatrix(i, this.n - 1, 0, this.dimension - 1));
        }
        this.points = M;
        this.n = this.points.getRowDimension();
        return this;
    }

    public PointType getPointType() {
        return this.pointType;
    }
}

