/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.misc;

import icy.common.listener.ProgressListener;
import icy.file.FileUtil;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.image.IcyBufferedImage;
import icy.imagej.ImageJUtil;
import icy.math.ArrayMath;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.collection.array.Array1DUtil;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import java.awt.image.BufferedImage;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.filtering.Convolution1D;
import plugins.adufour.filtering.ConvolutionException;
import plugins.adufour.filtering.Kernels1D;
import plugins.nchenouard.tvdenoising.TVDenoising;
import plugins.nchenouard.tvdenoising.TVFISTA;

public class Preprocess3Dstackto2D
extends EzPlug {
    EzVarSequence source;
    EzVarBoolean Applytoallchanels = new EzVarBoolean("STEP 1: Do you want to apply it to all channels: ", true);
    Sequence tobeprocessed;
    EzVarBoolean denoise = new EzVarBoolean("STEP 2: Do you want to denoise:", false);
    EzVarBoolean flatten = new EzVarBoolean("STEP 3: Do you want to flatten the image:", false);
    EzVarText choicemethodflatten = new EzVarText("Method of flatenning to be used", new String[]{"Do a maximum intensity projection", "Do a minimum intensity projection", "Create an optimized in focus slice (EDF EPFL Plugin)"}, 0, Boolean.valueOf(false));
    EzVarText choicemethoddenoising = new EzVarText("Level of denoising to be used", new String[]{"small make up", "big make-over"}, 0, Boolean.valueOf(false));
    EzVarDouble choiceobjectsize = new EzVarDouble("Approximate diameter of object (for bg removal) in pixel", 10.0, 0.0, 500.0, 100.0);
    EzVarText choicechannel;
    String[] listofChannelnames;

    public void clean() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        if (this.source.getValue() == null) {
            MessageDialog.showDialog((String)"Source was closed. Please open one and try again");
            throw new RuntimeException("Source was closed. Please open one and try again");
        }
        this.tobeprocessed = (Sequence)this.source.getValue();
        int sizet = this.tobeprocessed.getSizeT();
        int sizez = this.tobeprocessed.getSizeZ();
        if (!((Boolean)this.Applytoallchanels.getValue()).booleanValue()) {
            int indc = 0;
            for (int c = 0; c < this.listofChannelnames.length; ++c) {
                if (this.choicechannel.getValue() != this.listofChannelnames[c]) continue;
                indc = c;
            }
            String extractedchannelname = this.tobeprocessed.getChannelName(indc);
            this.tobeprocessed.beginUpdate();
            try {
                Sequence channelextracted = null;
                try {
                    channelextracted = SequenceUtil.extractChannel((Sequence)this.tobeprocessed, (int)indc);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.tobeprocessed.removeAllImages();
                for (int t = 0; t < sizet; ++t) {
                    for (int z = 0; z < sizez; ++z) {
                        IcyBufferedImage image = channelextracted.getImage(t, z);
                        this.tobeprocessed.setImage(t, z, (BufferedImage)image);
                    }
                }
            }
            finally {
                this.tobeprocessed.endUpdate();
                this.tobeprocessed.setChannelName(0, extractedchannelname);
                this.tobeprocessed.setFilename(this.tobeprocessed.getFilename() + " (" + extractedchannelname + ")");
                this.tobeprocessed.setName(this.tobeprocessed.getName() + " (" + extractedchannelname + ")");
            }
        }
        if (((Boolean)this.denoise.getValue()).booleanValue()) {
            int nbchannel = this.tobeprocessed.getSizeC();
            double objectdiameter = (Double)this.choiceobjectsize.getValue();
            Sequence duplicate1 = null;
            try {
                duplicate1 = SequenceUtil.getCopy((Sequence)this.tobeprocessed);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            duplicate1.beginUpdate();
            Kernels1D gaussianXY = Kernels1D.CUSTOM_GAUSSIAN.createGaussianKernel1D(objectdiameter);
            try {
                Convolution1D.convolve(duplicate1, gaussianXY.getData(), gaussianXY.getData(), null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (ConvolutionException e) {
                e.printStackTrace();
            }
            duplicate1.endUpdate();
            this.tobeprocessed.beginUpdate();
            try {
                for (int t = 0; t < this.tobeprocessed.getSizeT(); ++t) {
                    for (int z = 0; z < this.tobeprocessed.getSizeZ(); ++z) {
                        IcyBufferedImage image = this.substractbg(this.tobeprocessed, duplicate1, t, z);
                        this.tobeprocessed.setImage(t, z, (BufferedImage)image);
                    }
                }
            }
            finally {
                this.tobeprocessed.endUpdate();
            }
            Sequence duplicate2 = null;
            try {
                duplicate2 = SequenceUtil.getCopy((Sequence)this.tobeprocessed);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.tobeprocessed.beginUpdate();
            try {
                for (int t = 0; t < sizet; ++t) {
                    for (int z = 0; z < sizez; ++z) {
                        IcyBufferedImage imagedenoised = new IcyBufferedImage(duplicate2.getWidth(), duplicate2.getHeight(), nbchannel, duplicate2.getDataType_());
                        for (int c = 0; c < nbchannel; ++c) {
                            IcyBufferedImage imagedenoised2;
                            if (this.choicemethoddenoising.getValue() == "small make up") {
                                imagedenoised2 = TVDenoising.regularizeTVImage((IcyBufferedImage)duplicate2.getImage(t, z), (int)c, (int)10, (double)objectdiameter, (TVFISTA.RegularizationType)TVFISTA.RegularizationType.ISOTROPIC);
                                imagedenoised.setDataXY(c, imagedenoised2.getDataXY(0));
                                continue;
                            }
                            if (this.choicemethoddenoising.getValue() != "big make-over") continue;
                            imagedenoised2 = TVDenoising.regularizeTVImage((IcyBufferedImage)duplicate2.getImage(t, z), (int)c, (int)100, (double)(objectdiameter * 2.0), (TVFISTA.RegularizationType)TVFISTA.RegularizationType.ISOTROPIC);
                            imagedenoised.setDataXY(c, imagedenoised2.getDataXY(0));
                        }
                        this.tobeprocessed.setImage(t, z, (BufferedImage)imagedenoised);
                    }
                }
            }
            finally {
                this.tobeprocessed.endUpdate();
                this.tobeprocessed.setFilename(this.tobeprocessed.getFilename() + " (denoised)");
                this.tobeprocessed.setName(this.tobeprocessed.getName() + " (denoised)");
            }
        }
        if (this.choicemethodflatten.getValue() == "Do a maximum intensity projection" && ((Boolean)this.flatten.getValue()).booleanValue()) {
            this.tobeprocessed.removeAllROI();
            Sequence duplicate = null;
            try {
                duplicate = SequenceUtil.getCopy((Sequence)this.tobeprocessed);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            boolean max = true;
            this.tobeprocessed.removeAllImages();
            this.tobeprocessed.beginUpdate();
            try {
                for (int t = 0; t < sizet; ++t) {
                    IcyBufferedImage image2 = this.getProj(max, duplicate, t);
                    this.tobeprocessed.setImage(t, 0, (BufferedImage)image2);
                }
            }
            finally {
                this.tobeprocessed.endUpdate();
                this.tobeprocessed.setFilename(this.tobeprocessed.getFilename() + " (max projection)");
                this.tobeprocessed.setName(this.tobeprocessed.getName() + " (max projection)");
            }
        }
        if (this.choicemethodflatten.getValue() == "Do a minimum intensity projection" && ((Boolean)this.flatten.getValue()).booleanValue()) {
            this.tobeprocessed.removeAllROI();
            Sequence duplicate = null;
            try {
                duplicate = SequenceUtil.getCopy((Sequence)this.tobeprocessed);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            boolean max = false;
            this.tobeprocessed.removeAllImages();
            this.tobeprocessed.beginUpdate();
            try {
                for (int t = 0; t < duplicate.getSizeT(); ++t) {
                    IcyBufferedImage image2 = this.getProj(max, duplicate, t);
                    this.tobeprocessed.setImage(t, 0, (BufferedImage)image2);
                }
            }
            finally {
                this.tobeprocessed.endUpdate();
                this.tobeprocessed.setFilename(this.tobeprocessed.getFilename() + " (min projection)");
                this.tobeprocessed.setName(this.tobeprocessed.getName() + " (min projection)");
            }
        }
        if (this.choicemethodflatten.getValue() == "Create an optimized in focus slice (EDF EPFL Plugin)" && ((Boolean)this.flatten.getValue()).booleanValue()) {
            String directory = FileUtil.getApplicationDirectory() + "/" + "ij" + "/" + "plugins" + "/" + "EDF";
            if (!FileUtil.exists((String)directory)) {
                new ToolTipFrame("<html><br> EPFL ImageJ plugin seems not not be installed<br> download it here <a href=\"http://bigwww.epfl.ch/demo/edf/EDF.zip\">http://bigwww.epfl.ch/demo/edf/EDF.zip</a><br> Then unzip it under " + directory + "<br> and restart ICY</html>");
                return;
            }
            ProgressFrame progress = new ProgressFrame("Computing Optimized focus slice...");
            progress.setPosition(0.2);
            this.tobeprocessed.removeAllROI();
            Sequence[] arrayofimage = new Sequence[this.tobeprocessed.getSizeC()];
            for (int c = 0; c < this.tobeprocessed.getSizeC(); ++c) {
                Sequence tmpnew;
                ImagePlus test = null;
                try {
                    test = ImageJUtil.convertToImageJImage((Sequence)SequenceUtil.extractChannel((Sequence)this.tobeprocessed, (int)c), (ProgressListener)new ProgressListener(){

                        public boolean notifyProgress(double position, double length) {
                            return false;
                        }
                    });
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                test.show();
                IJ.run((String)"EDF Easy ", (String)"quality='4' topology='1' show-topology='off' show-view='off'");
                while (WindowManager.getImageCount() < 2) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ImagePlus test4 = IJ.getImage();
                Sequence test2 = null;
                try {
                    test2 = ImageJUtil.convertToIcySequence((ImagePlus)test4, (ProgressListener)new ProgressListener(){

                        public boolean notifyProgress(double position, double length) {
                            return false;
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                test4.close();
                test.close();
                progress.setPosition((double)(c / this.tobeprocessed.getSizeC()));
                IJ.run((String)"Close All");
                arrayofimage[c] = tmpnew = new Sequence(test2.getImage(0, 0));
            }
            this.tobeprocessed.beginUpdate();
            this.tobeprocessed.removeAllImages();
            try {
                Sequence tmp = SequenceUtil.concatC((Sequence[])arrayofimage);
                IcyBufferedImage test3 = tmp.getImage(0, 0);
                this.tobeprocessed.setImage(0, 0, (BufferedImage)test3);
            }
            finally {
                this.tobeprocessed.endUpdate();
                this.tobeprocessed.setFilename(this.tobeprocessed.getFilename() + " (Focused)");
                this.tobeprocessed.setName(this.tobeprocessed.getName() + " (Focused)");
            }
            progress.setPosition(1.0);
            progress.close();
        }
    }

    private IcyBufferedImage substractbg(Sequence ori, Sequence bg, int t, int z) {
        IcyBufferedImage result = new IcyBufferedImage(ori.getSizeX(), ori.getSizeY(), ori.getSizeC(), ori.getDataType_());
        for (int c = 0; c < ori.getSizeC(); ++c) {
            Object dataArrayori = ori.getDataXY(t, z, c);
            Object dataArrayBg = bg.getDataXY(t, z, c);
            double[] imgDoubleArray = Array1DUtil.arrayToDoubleArray((Object)dataArrayori, (boolean)ori.isSignedDataType());
            double[] imgDoubleArraybg = Array1DUtil.arrayToDoubleArray((Object)dataArrayBg, (boolean)bg.isSignedDataType());
            double[] dummyzeros = Array1DUtil.arrayToDoubleArray((Object)result.getDataXY(c), (boolean)result.isSignedDataType());
            ArrayMath.subtract((double[])imgDoubleArray, (double[])imgDoubleArraybg, (double[])imgDoubleArray);
            ArrayMath.max((double[])imgDoubleArray, (double[])dummyzeros, (double[])imgDoubleArray);
            Array1DUtil.doubleArrayToArray((double[])imgDoubleArray, (Object)result.getDataXY(c));
        }
        result.dataChanged();
        return result;
    }

    protected void initialize() {
        EzLabel textinfo = new EzLabel("Please select the image on which you want to preprocess (likely Light microscopy Image).");
        textinfo.setToolTipText("Once the transform will have been computed on this image, \n you can apply it to the full stack afterwards using ApplyTransformation.");
        this.source = new EzVarSequence("Select Source Image (will be closed and replaced)");
        this.addEzComponent((EzComponent)textinfo);
        this.addEzComponent((EzComponent)this.source);
        EzLabel textinfo3 = new EzLabel("Select the pre-processing to be applied.");
        textinfo3.setToolTipText("Once the transform will have been computed on this image, \n you can apply it to the full stack afterwards using ApplyTransformation.");
        this.addEzComponent((EzComponent)textinfo3);
        this.listofChannelnames = new String[((Sequence)this.source.getValue()).getSizeC()];
        for (int i = 0; i < ((Sequence)this.source.getValue()).getSizeC(); ++i) {
            this.listofChannelnames[i] = ((Sequence)this.source.getValue()).getChannelName(i);
        }
        this.choicechannel = new EzVarText("Work on Channel", this.listofChannelnames, 0, Boolean.valueOf(false));
        this.Applytoallchanels.setToolTipText("if unchecked you will have to select the channel on which it has to be applied \n (i.e the most useful to help the alignment)");
        this.flatten.setToolTipText("a 3D stack will become an optimized 2D image");
        this.addEzComponent((EzComponent)this.Applytoallchanels);
        this.addEzComponent((EzComponent)this.choicechannel);
        this.addEzComponent((EzComponent)this.denoise);
        this.addEzComponent((EzComponent)this.choicemethoddenoising);
        this.addEzComponent((EzComponent)this.choiceobjectsize);
        this.denoise.setToolTipText(" This will launch the Edge preserving smoothing (TV regularization) denoising plugin with some predefined settings");
        this.addEzComponent((EzComponent)this.flatten);
        this.addEzComponent((EzComponent)this.choicemethodflatten);
        if (((Sequence)this.source.getValue()).getSizeZ() > 1) {
            this.flatten.setVisible(true);
            this.choicemethodflatten.setVisible(true);
            this.flatten.addVisibilityTriggerTo((EzComponent)this.choicemethodflatten, (Object[])new Boolean[]{true});
        }
        if (((Sequence)this.source.getValue()).getSizeZ() == 1) {
            this.flatten.setVisible(false);
            this.choicemethodflatten.setVisible(false);
        }
        this.denoise.addVisibilityTriggerTo((EzComponent)this.choicemethoddenoising, (Object[])new Boolean[]{true});
        this.denoise.addVisibilityTriggerTo((EzComponent)this.choiceobjectsize, (Object[])new Boolean[]{true});
        this.Applytoallchanels.addVisibilityTriggerTo((EzComponent)this.choicechannel, (Object[])new Boolean[]{false});
        EzVarListener<Sequence> seqlistener = new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newseq) {
                if (source.getValue() != null) {
                    Preprocess3Dstackto2D.this.listofChannelnames = new String[((Sequence)source.getValue()).getSizeC()];
                    for (int i = 0; i < ((Sequence)source.getValue()).getSizeC(); ++i) {
                        Preprocess3Dstackto2D.this.listofChannelnames[i] = ((Sequence)source.getValue()).getChannelName(i);
                    }
                    Preprocess3Dstackto2D.this.choicechannel.setDefaultValues((Object[])Preprocess3Dstackto2D.this.listofChannelnames, 0, false);
                    if (((Sequence)source.getValue()).getSizeZ() > 1) {
                        Preprocess3Dstackto2D.this.flatten.setVisible(true);
                        Preprocess3Dstackto2D.this.choicemethodflatten.setVisible(true);
                        Preprocess3Dstackto2D.this.flatten.addVisibilityTriggerTo((EzComponent)Preprocess3Dstackto2D.this.choicemethodflatten, (Object[])new Boolean[]{true});
                    }
                    if (((Sequence)source.getValue()).getSizeZ() == 1) {
                        Preprocess3Dstackto2D.this.flatten.setVisible(false);
                        Preprocess3Dstackto2D.this.choicemethodflatten.setVisible(false);
                    }
                }
            }
        };
        this.source.addVarChangeListener((EzVarListener)seqlistener);
    }

    IcyBufferedImage getProj(boolean max, Sequence sequence, int t) {
        IcyBufferedImage result = new IcyBufferedImage(sequence.getSizeX(), sequence.getSizeY(), sequence.getSizeC(), sequence.getDataType_());
        if (!max) {
            result.setDataXY(0, sequence.getDataCopyCXY(t, 0));
        }
        for (int c = 0; c < sequence.getSizeC(); ++c) {
            double[] doubleArray = Array1DUtil.arrayToDoubleArray((Object)result.getDataXY(c), (boolean)result.isSignedDataType());
            for (int z = 0; z < sequence.getSizeZ(); ++z) {
                this.project(max, sequence, t, z, c, doubleArray);
            }
            Array1DUtil.doubleArrayToArray((double[])doubleArray, (Object)result.getDataXY(c));
        }
        result.dataChanged();
        return result;
    }

    void project(boolean max, Sequence sequence, int t, int z, int c, double[] result) {
        Object dataArray = sequence.getDataXY(t, z, c);
        double[] imgDoubleArray = Array1DUtil.arrayToDoubleArray((Object)dataArray, (boolean)sequence.isSignedDataType());
        if (max) {
            ArrayMath.max((double[])result, (double[])imgDoubleArray, (double[])result);
        } else {
            ArrayMath.min((double[])result, (double[])imgDoubleArray, (double[])result);
        }
    }
}

