/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.roi;

import icy.roi.ROI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import plugins.kernel.roi.roi3d.ROI3DPoint;

public class RoiProcessor {
    private Pattern pattern = Pattern.compile(".*?(\\d+)$");

    @Inject
    public RoiProcessor() {
    }

    public double[][] getPointsFromRoi(List<ROI> roiList) {
        if (roiList.size() == 0) {
            throw new RuntimeException("Dataset is empty");
        }
        int dimension = 3;
        this.sort(roiList);
        double[][] result = new double[roiList.size()][dimension];
        int i = -1;
        for (ROI roi : roiList) {
            result[++i] = this.getPointFromRoi(roi);
        }
        return result;
    }

    public double[] getPointFromRoi(ROI roi) {
        double[] result = new double[]{roi.getPosition5D().getX(), roi.getPosition5D().getY(), roi.getPosition5D().getZ() == Double.NEGATIVE_INFINITY ? 0.0 : roi.getPosition5D().getZ()};
        return result;
    }

    private void sort(List<ROI> roiList) {
        roiList.sort(Comparator.comparing(roi -> {
            Matcher matcher = this.pattern.matcher(roi.getName());
            matcher.matches();
            String group = matcher.group(1);
            return Integer.parseInt(group);
        }));
    }

    public void convert(ArrayList<ROI> roiList) {
        for (int i = 0; i < roiList.size(); ++i) {
            ROI roi = roiList.get(i);
            if (roi.getClassName().equals("plugins.kernel.roi.roi3d.ROI3DPoint")) continue;
            ROI3DPoint roi3D = new ROI3DPoint(roi.getPosition5D());
            roi3D.setName(roi.getName());
            roi3D.setColor(roi.getColor());
            roi3D.setStroke(roi.getStroke());
            roiList.set(i, (ROI)roi3D);
        }
    }
}

