/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.transformation;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.inject.Inject;
import javax.inject.Singleton;
import plugins.perrine.ec_clem.ec_clem.registration.AffineRegistrationParameterComputer;
import plugins.perrine.ec_clem.ec_clem.registration.NonLinearRegistrationParameterComputer;
import plugins.perrine.ec_clem.ec_clem.registration.RegistrationParameter;
import plugins.perrine.ec_clem.ec_clem.registration.RigidRegistrationParameterComputer;
import plugins.perrine.ec_clem.ec_clem.registration.SimilarityRegistrationParameterComputer;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;

@Singleton
public class RegistrationParameterFactory {
    private RigidRegistrationParameterComputer rigidTransformationComputer;
    private SimilarityRegistrationParameterComputer similarityTransformationComputer;
    private NonLinearRegistrationParameterComputer nonLinearTransformationComputer;
    private AffineRegistrationParameterComputer affineTransformationComputer;
    private LoadingCache<TransformationSchema, RegistrationParameter> cache = CacheBuilder.newBuilder().maximumSize(1000L).weakKeys().build(new CacheLoader<TransformationSchema, RegistrationParameter>(){

        @Override
        public RegistrationParameter load(TransformationSchema key) {
            return RegistrationParameterFactory.this.get(key);
        }
    });

    @Inject
    public RegistrationParameterFactory(RigidRegistrationParameterComputer rigidTransformationComputer, SimilarityRegistrationParameterComputer similarityTransformationComputer, NonLinearRegistrationParameterComputer nonLinearTransformationComputer, AffineRegistrationParameterComputer affineTransformationComputer) {
        this.rigidTransformationComputer = rigidTransformationComputer;
        this.similarityTransformationComputer = similarityTransformationComputer;
        this.nonLinearTransformationComputer = nonLinearTransformationComputer;
        this.affineTransformationComputer = affineTransformationComputer;
    }

    public RegistrationParameter getFrom(TransformationSchema transformationSchema) {
        return this.cache.getUnchecked(transformationSchema);
    }

    private RegistrationParameter get(TransformationSchema transformationSchema) {
        switch (transformationSchema.getTransformationType()) {
            case RIGID: {
                return this.rigidTransformationComputer.compute(transformationSchema.getFiducialSet());
            }
            case SIMILARITY: {
                return this.similarityTransformationComputer.compute(transformationSchema.getFiducialSet());
            }
            case AFFINE: {
                return this.affineTransformationComputer.compute(transformationSchema.getFiducialSet());
            }
            case SPLINE: {
                return this.nonLinearTransformationComputer.compute(transformationSchema.getFiducialSet());
            }
        }
        throw new RuntimeException("Case not implemented");
    }
}

