/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.transformation.schema;

import plugins.perrine.ec_clem.ec_clem.fiducialset.FiducialSet;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceName;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceSize;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.NoiseModel;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationType;

public class TransformationSchema {
    private FiducialSet fiducialSet;
    private TransformationType transformationType;
    private NoiseModel noiseModel;
    private SequenceSize sourceSize;
    private SequenceSize targetSize;
    private SequenceName sourceName;
    private SequenceName targetName;

    public TransformationSchema(FiducialSet fiducialSet, TransformationType transformationType, NoiseModel noiseModel, SequenceSize sourceSize, SequenceSize targetSize) {
        this.fiducialSet = fiducialSet;
        this.transformationType = transformationType;
        this.noiseModel = noiseModel;
        this.sourceSize = sourceSize;
        this.targetSize = targetSize;
        this.sourceName = new SequenceName();
        this.targetName = new SequenceName();
    }

    public TransformationSchema(FiducialSet fiducialSet, TransformationType transformationType, NoiseModel noiseModel, SequenceSize sourceSize, SequenceSize targetSize, SequenceName sourceName, SequenceName targetName) {
        this.fiducialSet = fiducialSet;
        this.transformationType = transformationType;
        this.noiseModel = noiseModel;
        this.sourceSize = sourceSize;
        this.targetSize = targetSize;
        this.sourceName = sourceName;
        this.targetName = targetName;
    }

    public FiducialSet getFiducialSet() {
        return this.fiducialSet;
    }

    public TransformationType getTransformationType() {
        return this.transformationType;
    }

    public NoiseModel getNoiseModel() {
        return this.noiseModel;
    }

    public SequenceSize getSourceSize() {
        return this.sourceSize;
    }

    public SequenceSize getTargetSize() {
        return this.targetSize;
    }

    public void setTargetSize(SequenceSize targetsize) {
        this.targetSize = targetsize;
    }

    public SequenceName getSourceName() {
        return this.sourceName;
    }

    public SequenceName getTargetName() {
        return this.targetName;
    }

    public TransformationSchema inverse() {
        return new TransformationSchema(new FiducialSet(this.fiducialSet.getTargetDataset(), this.fiducialSet.getSourceDataset()), this.transformationType, this.noiseModel, this.targetSize, this.sourceSize, this.targetName, this.sourceName);
    }
}

