/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.ui;

import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.util.XMLUtil;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.JButton;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;

public class ClearLandmarksButton
extends JButton {
    private Workspace workspace;

    @Inject
    public ClearLandmarksButton() {
        super("Clear all landmarks points");
        this.addActionListener(arg0 -> this.action());
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    private void action() {
        if (this.workspace.getSourceSequence() == null || this.workspace.getTargetSequence() == null) {
            MessageDialog.showDialog((String)"Make sure source and target image are openned and selected");
            return;
        }
        this.clearLandmarks(this.workspace.getSourceSequence());
        this.clearLandmarks(this.workspace.getTargetSequence());
        new AnnounceFrame("All fiducial points have been cleared", 5);
    }

    private void clearLandmarks(Sequence sequence) {
        this.saveROI(sequence);
        sequence.removeAllROI(true);
    }

    private void saveROI(Sequence sequence) {
        Document doc;
        ArrayList rois = sequence.getROIs();
        if (rois.size() > 0 && (doc = XMLUtil.createDocument((boolean)true)) != null) {
            ROI.saveROIsToXML((Node)XMLUtil.getRootElement((Document)doc), (List)rois);
            XMLUtil.saveDocument((Document)doc, (String)(sequence.getFilename() + "_ROIsavedBeforeClearLandmarks.xml"));
        }
    }
}

