/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.workspace;

import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.error.fitzpatrick.TREComputer;
import plugins.perrine.ec_clem.ec_clem.error.fitzpatrick.TREComputerFactory;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.DatasetFactory;
import plugins.perrine.ec_clem.ec_clem.monitor.MonitorTargetPoint;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressTrackableMasterTask;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;
import plugins.perrine.ec_clem.ec_clem.roi.RoiUpdater;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceFactory;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceUpdater;
import plugins.perrine.ec_clem.ec_clem.storage.transformation.csv.TransformationToCsvFileWriter;
import plugins.perrine.ec_clem.ec_clem.storage.transformation.xml.TransformationToXmlFileWriter;
import plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.writer.TransformationSchemaToXmlFileWriter;
import plugins.perrine.ec_clem.ec_clem.transformation.RegistrationParameterFactory;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchemaFactory;
import plugins.perrine.ec_clem.ec_clem.workspace.DaggerWorkspaceTransformerComponent;
import plugins.perrine.ec_clem.ec_clem.workspace.ResetOriginalImage;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;

public class WorkspaceTransformer
extends ProgressTrackableMasterTask
implements Runnable {
    private TransformationSchemaFactory transformationSchemaFactory;
    private TREComputerFactory treComputerFactory;
    private SequenceFactory sequenceFactory;
    private RegistrationParameterFactory registrationParameterFactory;
    private RoiUpdater roiUpdater;
    private DatasetFactory datasetFactory;
    private TransformationSchemaToXmlFileWriter transformationSchemaToXmlFileWriter;
    private TransformationToCsvFileWriter transformationToCsvFileWriter;
    private TransformationToXmlFileWriter transformationToXmlFileWriter;
    private Workspace workspace;

    public WorkspaceTransformer(Workspace workspace) {
        DaggerWorkspaceTransformerComponent.builder().build().inject(this);
        this.workspace = workspace;
    }

    @Override
    public void run() {
        ResetOriginalImage resetOriginalImage = new ResetOriginalImage(this.workspace);
        super.add(resetOriginalImage);
        resetOriginalImage.run();
        this.workspace.setTransformationSchema(this.transformationSchemaFactory.getFrom(this.workspace));
        if (this.workspace.getTransformationConfiguration().isShowGrid()) {
            Sequence gridSequence = this.sequenceFactory.getGridSequence(this.workspace.getSourceSequence().getSizeX(), this.workspace.getSourceSequence().getSizeY(), this.workspace.getSourceSequence().getSizeZ(), this.workspace.getSourceSequence().getPixelSizeX(), this.workspace.getSourceSequence().getPixelSizeY(), this.workspace.getSourceSequence().getPixelSizeZ());
            SequenceUpdater transformationGridSequenceUpdater = new SequenceUpdater(gridSequence, this.workspace.getTransformationSchema());
            super.add(transformationGridSequenceUpdater);
            transformationGridSequenceUpdater.run();
            ThreadUtil.invokeLater(() -> new Viewer(gridSequence));
        }
        SequenceUpdater sequenceUpdater = new SequenceUpdater(this.workspace.getSourceSequence(), this.workspace.getTransformationSchema());
        super.add(sequenceUpdater);
        sequenceUpdater.run();
        this.roiUpdater.updateRoi(this.datasetFactory.getFrom(this.workspace.getTargetSequence(), PointType.FIDUCIAL), this.workspace.getTargetSequence());
        this.roiUpdater.updateMeasuredErrorRoi(this.datasetFactory.toPixel(this.datasetFactory.getFrom(this.workspace.getSourceSequence(), PointType.FIDUCIAL), this.workspace.getSourceSequence()), this.datasetFactory.toPixel(this.datasetFactory.getFrom(this.workspace.getTargetSequence(), PointType.FIDUCIAL), this.workspace.getTargetSequence()), this.workspace.getSourceSequence());
        this.roiUpdater.setLayersVisible(this.workspace.getSourceSequence(), PointType.MEASURED_ERROR, this.workspace.getWorkspaceState().isShowMeasuredError());
        this.roiUpdater.setLayersVisible(this.workspace.getSourceSequence(), PointType.PREDICTED_ERROR, this.workspace.getWorkspaceState().isShowPredictedError());
        this.transformationSchemaToXmlFileWriter.save(this.workspace.getTransformationSchema(), this.workspace.getTransformationSchemaOutputFile());
        this.transformationToCsvFileWriter.save(this.registrationParameterFactory.getFrom(this.workspace.getTransformationSchema()).getTransformation(), this.workspace.getCsvTransformationOutputFile());
        this.transformationToXmlFileWriter.save(this.registrationParameterFactory.getFrom(this.workspace.getTransformationSchema()).getTransformation(), this.workspace.getTransformationSchema(), this.workspace.getXmlTransformationOutputFile());
        for (MonitorTargetPoint monitorTargetPoint : this.workspace.getMonitorTargetPoints()) {
            if (monitorTargetPoint.getMonitoringPoint() == null) continue;
            TREComputer treComputer = this.treComputerFactory.getFrom(this.workspace);
            monitorTargetPoint.UpdatePoint(this.workspace.getTransformationSchema().getFiducialSet().getN(), treComputer.getExpectedSquareTRE(monitorTargetPoint.getMonitoringPoint()));
        }
    }

    @Inject
    public void setTransformationSchemaFactory(TransformationSchemaFactory transformationSchemaFactory) {
        this.transformationSchemaFactory = transformationSchemaFactory;
    }

    @Inject
    public void setTreComputerFactory(TREComputerFactory treComputerFactory) {
        this.treComputerFactory = treComputerFactory;
    }

    @Inject
    public void setSequenceFactory(SequenceFactory sequenceFactory) {
        this.sequenceFactory = sequenceFactory;
    }

    @Inject
    public void setTransformationSchemaToXmlFileWriter(TransformationSchemaToXmlFileWriter transformationSchemaToXmlFileWriter) {
        this.transformationSchemaToXmlFileWriter = transformationSchemaToXmlFileWriter;
    }

    @Inject
    public void setTransformationToCsvFileWriter(TransformationToCsvFileWriter transformationToCsvFileWriter) {
        this.transformationToCsvFileWriter = transformationToCsvFileWriter;
    }

    @Inject
    public void setRegistrationParameterFactory(RegistrationParameterFactory registrationParameterFactory) {
        this.registrationParameterFactory = registrationParameterFactory;
    }

    @Inject
    public void setRoiUpdater(RoiUpdater roiUpdater) {
        this.roiUpdater = roiUpdater;
    }

    @Inject
    public void setDatasetFactory(DatasetFactory datasetFactory) {
        this.datasetFactory = datasetFactory;
    }

    @Inject
    public void setTransformationToXmlFileWriter(TransformationToXmlFileWriter transformationToXmlFileWriter) {
        this.transformationToXmlFileWriter = transformationToXmlFileWriter;
    }
}

