/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.filtering;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import plugins.adufour.filtering.Filter;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.util.VarListener;

public class Convolution
extends Filter {
    public static void convolve(Sequence input, Sequence kernel, boolean zeroEdges, int nbIter, VarBoolean stopFlag) {
        final Convolution c = new Convolution();
        VarListener<Boolean> l = new VarListener<Boolean>(){

            public void valueChanged(Var<Boolean> source, Boolean oldValue, Boolean newValue) {
                c.stopFlag.setValue((Object)newValue);
            }

            public void referenceChanged(Var<Boolean> source, Var<? extends Boolean> oldReference, Var<? extends Boolean> newReference) {
            }
        };
        stopFlag.addListener((VarListener)l);
        c.convolve(input, kernel, zeroEdges, nbIter);
        stopFlag.removeListener((VarListener)l);
        service.shutdown();
    }

    public Sequence convolve(Sequence sequence, Sequence kernel, final boolean zeroEdges, int nbIter) {
        Sequence out = new Sequence(sequence.getName() + "_" + this.getDescriptor().getName());
        final int width = sequence.getSizeX();
        final int height = sequence.getSizeY();
        final int depth = sequence.getSizeZ();
        int channels = sequence.getSizeC();
        int frames = sequence.getSizeT();
        final DataType type = sequence.getDataType_();
        boolean signed = type.isSigned();
        final double taskIncrement = 1.0 / (double)(height * depth * channels * sequence.getSizeT());
        final int kWidth = kernel.getSizeX() >> 1;
        final int kHeight = kernel.getSizeY() >> 1;
        final int kDepth = kernel.getSizeZ() >> 1;
        final Object[] in_Z_XY = new Object[depth];
        final double[] cache = new double[width * height];
        final double[][] _kernel = kernel.getDataXYZAsDouble(0, 0);
        ArrayList<Future> tasks = new ArrayList<Future>(height);
        block3: for (int t = 0; t < frames; ++t) {
            for (int z = 0; z < depth; ++z) {
                out.setImage(t, z, (BufferedImage)new IcyBufferedImage(width, height, channels, type));
            }
            for (int c = 0; c < channels; ++c) {
                for (int z = 0; z < depth; ++z) {
                    in_Z_XY[z] = sequence.getImage(t, z).getDataXY(c);
                }
                for (int i = 0; i < nbIter; ++i) {
                    for (int z = 0; z < depth; ++z) {
                        final int slice = z;
                        tasks.clear();
                        int y = 0;
                        while (y < height) {
                            final int line = y++;
                            tasks.add(service.submit(new Runnable(){

                                @Override
                                public void run() {
                                    int lineOffset;
                                    int outXY = lineOffset = line * width;
                                    int x = 0;
                                    while (x < width) {
                                        double conv = 0.0;
                                        for (int kZ = -kDepth; kZ <= kDepth; ++kZ) {
                                            int inZ = slice + kZ;
                                            if (inZ < 0) {
                                                if (zeroEdges) continue;
                                                inZ = -inZ + 1;
                                            } else if (inZ >= depth) {
                                                if (zeroEdges) continue;
                                                inZ = depth * 2 - inZ - 1;
                                            }
                                            Object in_XY = in_Z_XY[inZ];
                                            double[] k_XY = _kernel[kZ];
                                            int kXY = 0;
                                            for (int kY = -kHeight; kY <= kHeight; ++kY) {
                                                int inY = line + kY;
                                                if (inY < 0) {
                                                    if (zeroEdges) continue;
                                                    inY = -inY + 1;
                                                } else if (inY >= height) {
                                                    if (zeroEdges) continue;
                                                    inY = height * 2 - inY - 1;
                                                }
                                                int inXY = inY * width;
                                                int kX = -kWidth;
                                                while (kX <= kWidth) {
                                                    block15: {
                                                        int inX;
                                                        block16: {
                                                            block14: {
                                                                inX = x + kX;
                                                                if (inX >= 0) break block14;
                                                                if (zeroEdges) break block15;
                                                                inX = -inX + 1;
                                                                break block16;
                                                            }
                                                            if (inX < width) break block16;
                                                            if (zeroEdges) break block15;
                                                            inX = width * 2 - inX - 1;
                                                        }
                                                        conv += Array1DUtil.getValue((Object)in_XY, (int)(inXY + inX), (DataType)type) * k_XY[kXY];
                                                    }
                                                    ++kX;
                                                    ++kXY;
                                                }
                                            }
                                        }
                                        cache[outXY] = conv;
                                        ++x;
                                        ++outXY;
                                    }
                                    if (line % 3 == 0) {
                                        Convolution.this.progress.setValue((Object)(Convolution.this.progress.getValue() + taskIncrement * 3.0));
                                    }
                                }
                            }));
                            if (((Boolean)this.stopFlag.getValue()).booleanValue()) break;
                        }
                        try {
                            for (Future f : tasks) {
                                f.get();
                            }
                            Object out_XY = out.getDataXY(t, z, c);
                            Array1DUtil.doubleArrayToSafeArray((double[])cache, (int)0, (Object)out_XY, (int)0, (int)(width * height), (boolean)signed);
                            out.setDataXY(t, z, c, out_XY);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                        }
                        if (((Boolean)this.stopFlag.getValue()).booleanValue()) break block3;
                    }
                    if (((Boolean)this.stopFlag.getValue()).booleanValue()) break block3;
                }
            }
        }
        return out;
    }
}

