/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.filtering;

import com.nativelibs4java.opencl.CLBuildException;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLFloatBuffer;
import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.CLQueue;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import plugins.adufour.vars.lang.VarBoolean;

public class ConvolutionCL {
    public final CLProgram clProgram;
    public final CLContext clContext;
    public final CLQueue clQueue;
    public final CLEvent clEvent = null;

    public ConvolutionCL(CLContext context, CLProgram program, CLQueue queue) {
        this.clContext = context;
        this.clQueue = queue;
        this.clProgram = program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convolve(Sequence input, Sequence kernel, boolean zeroEdge, int nbIter, VarBoolean stopFlag) throws CLException, CLBuildException {
        String funcName = zeroEdge ? "convolve2D" : "convolve2D_mirror";
        CLKernel clKernel = this.clProgram.createKernel(funcName, new Object[0]);
        int dataSize = input.getSizeX() * input.getSizeY();
        float[] data = new float[dataSize];
        CLFloatBuffer cl_inBuffer = this.clContext.createFloatBuffer(CLMem.Usage.Input, dataSize);
        double[] kernelDouble = kernel.getDataXYAsDouble(0, 0, 0);
        CLFloatBuffer cl_kBuffer = this.clContext.createFloatBuffer(CLMem.Usage.Input, kernelDouble.length);
        FloatBuffer fb_k = (FloatBuffer)cl_kBuffer.map(this.clQueue, CLMem.MapFlags.Write, new CLEvent[0]);
        for (double d : kernelDouble) {
            fb_k.put((float)d);
        }
        fb_k.rewind();
        CLEvent event = cl_kBuffer.unmap(this.clQueue, fb_k, new CLEvent[0]);
        FloatBuffer outBuffer = ByteBuffer.allocateDirect(dataSize * 4).order(this.clContext.getByteOrder()).asFloatBuffer();
        CLFloatBuffer cl_outBuffer = this.clContext.createFloatBuffer(CLMem.Usage.Output, outBuffer, false);
        clKernel.setArgs(cl_inBuffer, input.getSizeX(), input.getSizeY(), cl_kBuffer, kernel.getSizeX() >> 1, kernel.getSizeY() >> 1, cl_outBuffer);
        DataType type = input.getDataType_();
        input.beginUpdate();
        try {
            for (int t = 0; t < input.getSizeT(); ++t) {
                for (int z = 0; z < input.getSizeZ(); ++z) {
                    IcyBufferedImage image = input.getImage(t, z);
                    for (int c = 0; c < input.getSizeC(); ++c) {
                        Array1DUtil.arrayToFloatArray((Object)image.getDataXY(c), (float[])data, (boolean)type.isSigned());
                        for (int i = 0; i < nbIter; ++i) {
                            FloatBuffer fb = (FloatBuffer)cl_inBuffer.map(this.clQueue, CLMem.MapFlags.Write, event);
                            fb.put(data);
                            fb.rewind();
                            event = cl_inBuffer.unmap(this.clQueue, fb, new CLEvent[0]);
                            event = clKernel.enqueueNDRange(this.clQueue, new int[]{data.length}, event);
                            event = cl_outBuffer.read(this.clQueue, outBuffer, true, event);
                            outBuffer.get(data);
                            outBuffer.rewind();
                            Object dest = image.getDataXY(c);
                            Array1DUtil.floatArrayToSafeArray((float[])data, (Object)dest, (boolean)type.isSigned());
                            image.setDataXY(c, dest);
                            if (!((Boolean)stopFlag.getValue()).booleanValue()) continue;
                            return;
                        }
                    }
                }
            }
        }
        finally {
            input.endUpdate();
        }
    }
}

