/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.cascade_transform;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarText;
import plugins.perrine.ec_clem.cascade_transform.DaggerEcClemCascadeTransformComponent;
import plugins.perrine.ec_clem.cascade_transform.EzVarFileList;
import plugins.perrine.ec_clem.ec_clem.fiducialset.FiducialSet;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.registration.RegistrationParameter;
import plugins.perrine.ec_clem.ec_clem.storage.transformation.xml.TransformationToXmlFileWriter;
import plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.reader.XmlToTransformationSchemaFileReader;
import plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.writer.TransformationSchemaToXmlFileWriter;
import plugins.perrine.ec_clem.ec_clem.transformation.RegistrationParameterFactory;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.NoiseModel;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationType;

public class EcClemCascadeTransform
extends EzPlug
implements Block {
    private EzVarFileList fileList = new EzVarFileList("Schema list");
    private EzVarText keepSelection = new EzVarText("Keep:", KeepType.toArray(), 0, Boolean.valueOf(false));
    private EzVarFile outputFile = new EzVarFile("Output transformation schema", null);
    private XmlToTransformationSchemaFileReader xmlToTransformationSchemaFileReader;
    private TransformationSchemaToXmlFileWriter transformationSchemaToXmlFileWriter;
    private TransformationToXmlFileWriter transformationToXmlFileWriter;
    private RegistrationParameterFactory registrationParameterFactory;

    public EcClemCascadeTransform() {
        DaggerEcClemCascadeTransformComponent.builder().build().inject(this);
    }

    public void declareInput(VarList varList) {
        varList.add("0", this.fileList.getVariable());
        varList.add("1", this.keepSelection.getVariable());
        varList.add("2", this.outputFile.getVariable());
    }

    public void declareOutput(VarList varList) {
    }

    protected void initialize() {
        this.addEzComponent((EzComponent)this.fileList);
        this.addEzComponent((EzComponent)this.keepSelection);
        this.addEzComponent((EzComponent)this.outputFile);
    }

    protected void execute() {
        this.fileList.setEnabled(false);
        this.keepSelection.setEnabled(false);
        this.outputFile.setEnabled(false);
        List files = (List)this.fileList.getValue();
        List<TransformationSchema> schemas = this.getTransformationSchemaList(files);
        TransformationSchema result = null;
        if (KeepType.valueOf((String)this.keepSelection.getValue()).equals((Object)KeepType.TARGET_DATASET_FROM_LAST)) {
            LinkedList<TransformationSchema> inversed = new LinkedList<TransformationSchema>();
            for (TransformationSchema schema : schemas) {
                inversed.add(0, schema.inverse());
            }
            TransformationSchema newTransformationSchema = this.getNewTransformationSchema(inversed);
            result = newTransformationSchema.inverse();
        } else {
            result = this.getNewTransformationSchema(schemas);
        }
        File correctedoutputFile = (File)this.outputFile.getValue(true);
        if (!((File)this.outputFile.getValue()).getPath().endsWith(".xml")) {
            correctedoutputFile = new File(((File)this.outputFile.getValue()).getPath() + ".xml");
        }
        this.transformationSchemaToXmlFileWriter.save(result, correctedoutputFile);
        RegistrationParameter from = this.registrationParameterFactory.getFrom(result);
        this.transformationToXmlFileWriter.save(from.getTransformation(), result, new File(correctedoutputFile.getPath().replace(".xml", "matrix.xml")));
        this.fileList.setEnabled(true);
        this.keepSelection.setEnabled(true);
        this.outputFile.setEnabled(true);
    }

    private TransformationSchema getNewTransformationSchema(List<TransformationSchema> schemas) {
        TransformationType transformationType = this.getTransformationType(schemas);
        NoiseModel noiseModel = this.getNoiseModel(schemas);
        Dataset transformedDataset = schemas.get(0).getFiducialSet().getSourceDataset();
        for (int i = 0; i < schemas.size(); ++i) {
            RegistrationParameter from = this.registrationParameterFactory.getFrom(schemas.get(i));
            transformedDataset = from.getTransformation().apply(transformedDataset);
        }
        return new TransformationSchema(new FiducialSet(schemas.get(0).getFiducialSet().getSourceDataset(), transformedDataset), transformationType, noiseModel, schemas.get(0).getSourceSize(), schemas.get(schemas.size() - 1).getTargetSize(), schemas.get(0).getSourceName(), schemas.get(schemas.size() - 1).getTargetName());
    }

    private List<TransformationSchema> getTransformationSchemaList(List<File> files) {
        LinkedList<TransformationSchema> list = new LinkedList<TransformationSchema>();
        for (File file : files) {
            list.add(this.xmlToTransformationSchemaFileReader.read(file));
        }
        return list;
    }

    private TransformationType getTransformationType(List<TransformationSchema> schemas) {
        TransformationType type = TransformationType.RIGID;
        block6: for (TransformationSchema schema : schemas) {
            switch (schema.getTransformationType()) {
                case RIGID: {
                    continue block6;
                }
                case SIMILARITY: {
                    if (type != TransformationType.RIGID) continue block6;
                    type = TransformationType.SIMILARITY;
                    continue block6;
                }
                case AFFINE: {
                    if (type != TransformationType.RIGID && type != TransformationType.SIMILARITY) continue block6;
                    type = TransformationType.AFFINE;
                    continue block6;
                }
                case SPLINE: {
                    return TransformationType.SPLINE;
                }
            }
            throw new RuntimeException("Unsupported type");
        }
        return type;
    }

    private NoiseModel getNoiseModel(List<TransformationSchema> schemas) {
        NoiseModel noiseModel = NoiseModel.ISOTROPIC;
        block4: for (TransformationSchema schema : schemas) {
            switch (schema.getNoiseModel()) {
                case ISOTROPIC: {
                    continue block4;
                }
                case ANISOTROPIC: {
                    return NoiseModel.ANISOTROPIC;
                }
            }
            throw new RuntimeException("Unsupported type");
        }
        return noiseModel;
    }

    public void clean() {
    }

    @Inject
    public void setXmlToTransformationSchemaFileReader(XmlToTransformationSchemaFileReader xmlToTransformationSchemaFileReader) {
        this.xmlToTransformationSchemaFileReader = xmlToTransformationSchemaFileReader;
    }

    @Inject
    public void setTransformationSchemaToXmlFileWriter(TransformationSchemaToXmlFileWriter transformationSchemaToXmlFileWriter) {
        this.transformationSchemaToXmlFileWriter = transformationSchemaToXmlFileWriter;
    }

    @Inject
    public void setRegistrationParameterFactory(RegistrationParameterFactory registrationParameterFactory) {
        this.registrationParameterFactory = registrationParameterFactory;
    }

    @Inject
    public void setTransformationToXmlFileWriter(TransformationToXmlFileWriter transformationToXmlFileWriter) {
        this.transformationToXmlFileWriter = transformationToXmlFileWriter;
    }

    private static enum KeepType {
        SOURCE_DATASET_FROM_FIRST,
        TARGET_DATASET_FROM_LAST;


        public static String[] toArray() {
            List collect = Arrays.stream(KeepType.values()).map(Enum::name).collect(Collectors.toList());
            String[] array = new String[collect.size()];
            for (int i = 0; i < collect.size(); ++i) {
                array[i] = (String)collect.get(i);
            }
            return array;
        }
    }
}

