/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.error.fitzpatrick;

import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import plugins.perrine.ec_clem.ec_clem.error.fitzpatrick.RegistrationError;

public class RegistrationErrorStatistics {
    private List<Double> predictedError = new ArrayList<Double>();
    private List<Double> measuredError = new ArrayList<Double>();
    private List<Double> distanceToBarycentre = new ArrayList<Double>();

    public void add(RegistrationError registrationError) {
        this.predictedError.add(registrationError.getPredictedError());
        this.measuredError.add(registrationError.getMeasuredError());
        this.distanceToBarycentre.add(registrationError.getDistanceToBarycentre());
    }

    public List<Double> getPredictedError() {
        return this.predictedError;
    }

    public List<Double> getMeasuredError() {
        return this.measuredError;
    }

    public List<Double> getDistanceToBarycentre() {
        return this.distanceToBarycentre;
    }

    public DoubleSummaryStatistics getPredictedErrorStatistic() {
        return this.predictedError.stream().mapToDouble(x -> x).summaryStatistics();
    }

    public DoubleSummaryStatistics getMeasuredErrorStatistic() {
        return this.measuredError.stream().mapToDouble(x -> x).summaryStatistics();
    }

    public DoubleSummaryStatistics getDistanceToBarycentreStatistic() {
        return this.distanceToBarycentre.stream().mapToDouble(x -> x).summaryStatistics();
    }
}

