/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.fiducialset.dataset;

import Jama.Matrix;
import icy.sequence.Sequence;
import java.util.ArrayList;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;
import plugins.perrine.ec_clem.ec_clem.roi.RoiFactory;
import plugins.perrine.ec_clem.ec_clem.roi.RoiProcessor;
import plugins.perrine.ec_clem.ec_clem.transformation.RegistrationParameterFactory;
import plugins.perrine.ec_clem.ec_clem.transformation.Transformation;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;
import vtk.vtkPolyData;

public class DatasetFactory {
    private RoiProcessor roiProcessor;
    private RoiFactory roiFactory;
    private RegistrationParameterFactory transformationFactory;

    @Inject
    public DatasetFactory(RoiProcessor roiProcessor, RoiFactory roiFactory, RegistrationParameterFactory transformationFactory) {
        this.roiProcessor = roiProcessor;
        this.roiFactory = roiFactory;
        this.transformationFactory = transformationFactory;
    }

    public Dataset getFrom(Sequence sequence, PointType pointType) {
        Dataset dataset;
        try {
            dataset = new Dataset(this.roiProcessor.getPointsFromRoi(this.roiFactory.getFrom(sequence, pointType)), pointType);
        }
        catch (RuntimeException e) {
            dataset = new Dataset(0, pointType);
        }
        return this.toMicroMeter(dataset, sequence);
    }

    public Dataset getFrom(vtkPolyData points, PointType pointType) {
        ArrayList<Point> pointList = new ArrayList<Point>();
        int i = 0;
        while ((long)i < points.GetNumberOfPoints()) {
            double[] point = points.GetPoint((long)i);
            pointList.add(new Point(point));
            ++i;
        }
        return new Dataset(pointList, pointType);
    }

    public Dataset getFrom(Dataset dataset, TransformationSchema transformationSchema) {
        Dataset transformedDataset;
        Transformation transformation = this.transformationFactory.getFrom(transformationSchema).getTransformation();
        try {
            transformedDataset = transformation.apply(dataset);
        }
        catch (Exception e) {
            transformedDataset = dataset;
        }
        return transformedDataset;
    }

    public Dataset toPixel(Dataset dataset, Sequence sequence) {
        Matrix M = dataset.getMatrix().copy();
        for (int d = 0; d < dataset.getDimension(); ++d) {
            if (d == 0) {
                M.setMatrix(0, dataset.getN() - 1, d, d, M.getMatrix(0, dataset.getN() - 1, d, d).times(1.0 / sequence.getPixelSizeX()));
            }
            if (d == 1) {
                M.setMatrix(0, dataset.getN() - 1, d, d, M.getMatrix(0, dataset.getN() - 1, d, d).times(1.0 / sequence.getPixelSizeY()));
            }
            if (d != 2) continue;
            M.setMatrix(0, dataset.getN() - 1, d, d, M.getMatrix(0, dataset.getN() - 1, d, d).times(1.0 / sequence.getPixelSizeZ()));
        }
        return new Dataset(M, dataset.getPointType());
    }

    private Dataset toMicroMeter(Dataset dataset, Sequence sequence) {
        Matrix M = dataset.getMatrix().copy();
        for (int d = 0; d < dataset.getDimension(); ++d) {
            if (d == 0) {
                M.setMatrix(0, dataset.getN() - 1, d, d, M.getMatrix(0, dataset.getN() - 1, d, d).times(sequence.getPixelSizeX()));
            }
            if (d == 1) {
                M.setMatrix(0, dataset.getN() - 1, d, d, M.getMatrix(0, dataset.getN() - 1, d, d).times(sequence.getPixelSizeY()));
            }
            if (d != 2) continue;
            M.setMatrix(0, dataset.getN() - 1, d, d, M.getMatrix(0, dataset.getN() - 1, d, d).times(sequence.getPixelSizeZ()));
        }
        return new Dataset(M, dataset.getPointType());
    }
}

