/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point;

import Jama.Matrix;
import java.util.Arrays;
import java.util.List;

public class Point {
    private Matrix coordinates;

    public Point(int dimension) {
        this.coordinates = new Matrix(dimension, 1, 0.0);
    }

    public Point(Matrix matrix) {
        this.coordinates = matrix;
    }

    public Point(double[] coordinates) {
        this.coordinates = new Matrix(coordinates.length, 1);
        for (int i = 0; i < coordinates.length; ++i) {
            this.coordinates.set(i, 0, coordinates[i]);
        }
    }

    public int getDimension() {
        return this.coordinates.getRowDimension();
    }

    public double get(int i) {
        return this.coordinates.get(i, 0);
    }

    public Matrix getMatrix() {
        return this.coordinates;
    }

    public double getDistance(Point point) {
        return this.coordinates.minus(point.getMatrix()).norm2();
    }

    public double getSquareDistance(Matrix axis, Matrix pointOnTheAxis) {
        return new Point(this.coordinates.minus(pointOnTheAxis).minus(axis.times(this.coordinates.transpose().times(axis).get(0, 0) / axis.transpose().times(axis).get(0, 0)))).getSumOfSquare();
    }

    public Point minus(Point point) {
        return new Point(this.coordinates.minus(point.getMatrix()));
    }

    public Point plus(Point point) {
        return new Point(this.coordinates.plus(point.getMatrix()));
    }

    public double getSumOfSquare() {
        return this.coordinates.transpose().times(this.coordinates).get(0, 0);
    }

    public Point getNearest(List<Point> list) {
        Point nearest = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            Point current = list.get(i);
            if (!(this.getDistance(current) < this.getDistance(nearest))) continue;
            nearest = current;
        }
        return nearest;
    }

    public String toString() {
        return "Point{coordinates=" + Arrays.deepToString((Object[])this.coordinates.getArray()) + '}';
    }
}

