/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.registration;

import Jama.Matrix;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.fiducialset.FiducialSet;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.registration.RegistrationParameter;
import plugins.perrine.ec_clem.ec_clem.registration.RegistrationParameterComputer;
import plugins.perrine.ec_clem.ec_clem.sequence.VtkPointsFactory;
import plugins.perrine.ec_clem.ec_clem.transformation.DaggerSplineTransformationComponent;
import plugins.perrine.ec_clem.ec_clem.transformation.SplineTransformationComponent;
import vtk.vtkThinPlateSplineTransform;

public class NonLinearRegistrationParameterComputer
implements RegistrationParameterComputer {
    private SplineTransformationComponent splineTransformationComponent;
    private VtkPointsFactory vtkPointsFactory;

    @Inject
    public NonLinearRegistrationParameterComputer(VtkPointsFactory vtkPointsFactory) {
        this.vtkPointsFactory = vtkPointsFactory;
        this.splineTransformationComponent = DaggerSplineTransformationComponent.create();
    }

    @Override
    public RegistrationParameter compute(FiducialSet fiducialSet) {
        return this.compute(fiducialSet.getSourceDataset(), fiducialSet.getTargetDataset());
    }

    private RegistrationParameter compute(Dataset sourceDataset, Dataset targetDataset) {
        vtkThinPlateSplineTransform vtkSplineTransformation = new vtkThinPlateSplineTransform();
        vtkSplineTransformation.SetSourceLandmarks(this.vtkPointsFactory.getFrom(sourceDataset));
        vtkSplineTransformation.SetTargetLandmarks(this.vtkPointsFactory.getFrom(targetDataset));
        vtkSplineTransformation.SetBasisToR2LogR();
        return new RegistrationParameter(this.splineTransformationComponent.getSplineTransformation().setSplineTransform(vtkSplineTransformation), Matrix.identity((int)sourceDataset.getDimension(), (int)targetDataset.getDimension()), Double.NaN);
    }
}

