/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.sequence;

import icy.sequence.Sequence;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.DatasetFactory;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressTrackableMasterTask;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;
import plugins.perrine.ec_clem.ec_clem.roi.RoiUpdater;
import plugins.perrine.ec_clem.ec_clem.sequence.DaggerSequenceUpdaterComponent;
import plugins.perrine.ec_clem.ec_clem.sequence.Stack3DVTKTransformer;
import plugins.perrine.ec_clem.ec_clem.transformation.RegistrationParameterFactory;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;

public class SequenceUpdater
extends ProgressTrackableMasterTask
implements Runnable {
    private RegistrationParameterFactory transformationFactory;
    private DatasetFactory datasetFactory;
    private RoiUpdater roiUpdater;
    private Sequence sourceSequence;
    private TransformationSchema transformationSchema;

    public SequenceUpdater(Sequence sourceSequence, TransformationSchema transformationSchema) {
        DaggerSequenceUpdaterComponent.builder().build().inject(this);
        this.sourceSequence = sourceSequence;
        this.transformationSchema = transformationSchema;
    }

    @Override
    public void run() {
        Dataset sourceFiducialDataset = this.datasetFactory.getFrom(this.sourceSequence, PointType.FIDUCIAL);
        Dataset sourceNonFiducialDataset = this.datasetFactory.getFrom(this.sourceSequence, PointType.NOT_FIDUCIAL);
        Dataset sourceTransformedDataset = this.datasetFactory.getFrom(sourceFiducialDataset, this.transformationSchema);
        Dataset sourceNonFiducialTransformedDataset = this.datasetFactory.getFrom(sourceNonFiducialDataset, this.transformationSchema);
        Stack3DVTKTransformer imageTransformer = new Stack3DVTKTransformer(this.sourceSequence, this.transformationSchema.getTargetSize(), this.transformationFactory.getFrom(this.transformationSchema).getTransformation());
        super.add(imageTransformer);
        this.sourceSequence = imageTransformer.get();
        this.roiUpdater.clear(this.sourceSequence, PointType.PREDICTED_ERROR);
        this.roiUpdater.clear(this.sourceSequence, PointType.MEASURED_ERROR);
        try {
            this.roiUpdater.updateErrorRoi(sourceNonFiducialDataset, this.transformationSchema, this.sourceSequence);
            this.roiUpdater.updateErrorRoi(sourceFiducialDataset, this.transformationSchema, this.sourceSequence);
        }
        catch (RuntimeException e) {
            System.err.println(String.format("Error estimation aborted because there is not enough fiducial points : %s", e.getMessage()));
        }
        this.roiUpdater.updateRoi(sourceTransformedDataset, this.sourceSequence);
        this.roiUpdater.updateRoi(sourceNonFiducialTransformedDataset, this.sourceSequence);
    }

    @Inject
    public void setTransformationFactory(RegistrationParameterFactory transformationFactory) {
        this.transformationFactory = transformationFactory;
    }

    @Inject
    public void setDatasetFactory(DatasetFactory datasetFactory) {
        this.datasetFactory = datasetFactory;
    }

    @Inject
    public void setRoiUpdater(RoiUpdater roiUpdater) {
        this.roiUpdater = roiUpdater;
    }
}

