/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.storage.transformation.xml;

import icy.util.XMLUtil;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlFiletoTransformationReader {
    public double[][] read(Document document) {
        Element transfo = (Element)XMLUtil.getElements((Node)document.getDocumentElement(), (String)"MatrixTransformation").get(0);
        Element transfoinfo = (Element)XMLUtil.getElements((Node)document.getDocumentElement(), (String)"transformation").get(0);
        ArrayList sequenceSizeElements = XMLUtil.getElements((Node)transfoinfo, (String)"sequenceSize");
        if (sequenceSizeElements.size() != 2) {
            throw new RuntimeException("Element should contain exactly 2 sequenceSize");
        }
        double sourceSequenceSize = this.readSequenceSize((Element)sequenceSizeElements.get(0));
        double targetSequenceSize = this.readSequenceSize((Element)sequenceSizeElements.get(1));
        if (((Element)sequenceSizeElements.get(0)).getAttribute("type").equals("target")) {
            double tmp = sourceSequenceSize;
            sourceSequenceSize = targetSequenceSize;
            targetSequenceSize = tmp;
        }
        double[][] m = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                m[i][j] = XMLUtil.getAttributeDoubleValue((Element)transfo, (String)("m" + String.valueOf(i) + String.valueOf(j)), (double)0.0);
            }
        }
        return m;
    }

    private double readSequenceSize(Element element) {
        double pixelsizeum = 1.0;
        ArrayList elements = XMLUtil.getElements((Node)element);
        for (Element dimension : elements) {
            String dim = dimension.getAttribute("name");
            if (dim.compareTo("X") != 0) continue;
            pixelsizeum = Double.parseDouble(dimension.getAttribute("pixelSize"));
        }
        return pixelsizeum;
    }
}

