/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.ui;

import icy.gui.dialog.MessageDialog;
import icy.gui.viewer.Viewer;
import icy.system.thread.ThreadUtil;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.swing.JButton;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceMerger;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;

public class MergeButton
extends JButton {
    private Workspace workspace;

    @Inject
    public MergeButton() {
        super("Merge sequences");
        this.addActionListener(arg0 -> this.action());
    }

    private void action() {
        try {
            SequenceMerger sequenceMerger = new SequenceMerger(this.workspace.getSourceSequence(), this.workspace.getTargetSequence());
            CompletableFuture.supplyAsync(sequenceMerger).thenAccept(sequence -> ThreadUtil.invokeLater(() -> new Viewer(sequence)));
        }
        catch (RuntimeException e) {
            MessageDialog.showDialog((String)e.getMessage(), (int)0);
        }
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }
}

