/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.ui;

import icy.gui.frame.progress.ProgressFrame;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressManager;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressReport;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressTrackable;

public class ProgressBarManager
extends ProgressManager {
    private Map<ProgressTrackable, ProgressFrame> bars = new HashMap<ProgressTrackable, ProgressFrame>();
    private Map<ProgressTrackable, ScheduledFuture> schedules = new HashMap<ProgressTrackable, ScheduledFuture>();
    private ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    @Inject
    public ProgressBarManager() {
    }

    @Override
    public void update(Observable observable, Object o) {
        super.subscribe((ProgressTrackable)o);
    }

    @Override
    public void add(ProgressTrackable progressTrackable) {
        ProgressFrame progressFrame = new ProgressFrame(progressTrackable.getClass().getSimpleName());
        progressFrame.setLength((double)progressTrackable.getProgress().getTotal());
        progressFrame.setPosition(0.0);
        this.bars.put(progressTrackable, progressFrame);
        this.schedules.put(progressTrackable, this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.handle(progressTrackable), 0L, 1L, TimeUnit.SECONDS));
    }

    private void handle(ProgressTrackable task) {
        ProgressReport progress = task.getProgress();
        this.bars.get(task).setPosition((double)progress.getCompleted());
        this.bars.get(task).setMessage(String.format("%s - %d completed / %d total", task.getClass().getSimpleName(), progress.getCompleted(), progress.getTotal()));
        if (progress.isCompleted()) {
            this.schedules.remove(task).cancel(false);
            this.bars.remove(task).close();
        }
    }
}

